/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.entry.PageValue;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.parts.GuideChapter;
import buildcraft.lib.client.guide.parts.GuideChapterContents;
import buildcraft.lib.client.guide.parts.GuideChapterWithin;
import buildcraft.lib.client.guide.parts.GuidePageBase;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.GuidePartGroup;
import buildcraft.lib.client.guide.parts.GuidePartNewPage;
import buildcraft.lib.client.guide.ref.GuideGroupManager;
import buildcraft.lib.client.guide.ref.GuideGroupSet;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StringUtilBC;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class GuidePage
extends GuidePageBase {
    public final ImmutableList<GuidePart> parts;
    public final String title;
    public final GuideChapter chapterContents;
    public final PageValue<?> entry;

    public GuidePage(GuiGuide gui, List<GuidePart> parts, PageValue<?> entry) {
        super(gui);
        this.title = StringUtilBC.formatStringForWhite(entry.title);
        this.chapterContents = new GuideChapterContents(gui);
        this.entry = entry;
        List<GuidePart> from = parts;
        parts = new ArrayList<GuidePart>();
        parts.add(new GuideChapterWithin(gui, this.title));
        parts.addAll(from);
        ArrayList<GuidePartGroup> linksToOther = new ArrayList<GuidePartGroup>();
        ArrayList<GuidePartGroup> linksToThis = new ArrayList<GuidePartGroup>();
        PageValue<?> value = entry.copyToValue();
        for (GuideGroupSet set : GuideGroupManager.sets.values()) {
            if (set.sources.contains(value)) {
                linksToOther.add(new GuidePartGroup(gui, set, GuideGroupSet.GroupDirection.SRC_TO_ENTRY));
                continue;
            }
            if (!set.entries.contains(value)) continue;
            linksToThis.add(new GuidePartGroup(gui, set, GuideGroupSet.GroupDirection.ENTRY_TO_SRC));
        }
        linksToOther.removeAll(parts);
        linksToThis.removeAll(parts);
        if (!linksToOther.isEmpty()) {
            parts.add(new GuideChapterWithin(gui, LocaleUtil.localize("buildcraft.guide.meta.group.linking_to")));
            for (GuidePartGroup g : linksToOther) {
                parts.add(g);
                parts.add(new GuidePartNewPage(gui));
            }
        }
        if (!linksToThis.isEmpty()) {
            parts.add(new GuideChapterWithin(gui, LocaleUtil.localize("buildcraft.guide.meta.group.linked_from")));
            for (GuidePartGroup g : linksToThis) {
                parts.add(g);
                parts.add(new GuidePartNewPage(gui));
            }
        }
        GuidePage.addTypeSpecific(gui, parts, entry);
        this.parts = ImmutableList.copyOf(parts);
        this.setupChapters();
    }

    private static <T> void addTypeSpecific(GuiGuide gui, List<GuidePart> parts, PageValue<T> entry) {
        entry.type.addPageEntries(entry.value, gui, parts);
    }

    @Override
    public List<GuideChapter> getChapters() {
        ArrayList<GuideChapter> list = new ArrayList<GuideChapter>();
        list.add(this.chapterContents);
        for (GuidePart part : this.parts) {
            if (!(part instanceof GuideChapter)) continue;
            list.add((GuideChapter)part);
        }
        return list;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setFontRenderer(IFontRenderer fontRenderer) {
        super.setFontRenderer(fontRenderer);
        for (GuidePart part : this.parts) {
            part.setFontRenderer(fontRenderer);
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        for (GuidePart part : this.parts) {
            part.updateScreen();
        }
    }

    @Override
    protected void renderPage(int x, int y, int width, int height, int index) {
        super.renderPage(x, y, width, height, index);
        GuidePart.PagePosition part = new GuidePart.PagePosition(0, 0);
        for (GuidePart guidePart : this.parts) {
            part = guidePart.renderIntoArea(x, y, width, height, part, index);
            if (this.numPages == -1 || part.page <= index) continue;
            break;
        }
        if (this.numPages == -1) {
            this.numPages = part.newPage().page;
        }
    }

    @Override
    public void handleMouseClick(int x, int y, int width, int height, int mouseX, int mouseY, int mouseButton, int index, boolean isEditing) {
        super.handleMouseClick(x, y, width, height, mouseX, mouseY, mouseButton, index, isEditing);
        GuidePart.PagePosition part = new GuidePart.PagePosition(0, 0);
        for (GuidePart guidePart : this.parts) {
            part = guidePart.handleMouseClick(x, y, width, height, part, index, mouseX, mouseY);
            if (this.numPages == -1 || part.page <= index) continue;
            break;
        }
    }
}

