/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model.json;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.model.ModelHolderRegistry;
import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.model.ResourceLoaderContext;
import buildcraft.lib.client.model.json.JsonModelRule;
import buildcraft.lib.client.model.json.JsonTexture;
import buildcraft.lib.client.model.json.JsonVariableModelPart;
import buildcraft.lib.client.reload.ReloadManager;
import buildcraft.lib.client.reload.ReloadSource;
import buildcraft.lib.client.reload.SourceType;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.json.JsonVariableObject;
import buildcraft.lib.misc.JsonUtil;
import buildcraft.lib.misc.SpriteUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class JsonVariableModel
extends JsonVariableObject {
    public final boolean ambientOcclusion;
    public final Map<String, JsonTexture> textures;
    public final JsonModelRule[] rules;
    public final JsonVariableModelPart[] cutoutElements;
    public final JsonVariableModelPart[] translucentElements;

    public static JsonVariableModel deserialize(ResourceLocation from, FunctionContext fnCtx) throws JsonParseException, IOException {
        return JsonVariableModel.deserialize(from, fnCtx, new ResourceLoaderContext());
    }

    /*
     * Loose catch block
     */
    public static JsonVariableModel deserialize(ResourceLocation from, FunctionContext fnCtx, ResourceLoaderContext ctx) throws JsonParseException, IOException {
        try {
            try (InputStreamReader isr = ctx.startLoading(from);){
                JsonVariableModel jsonVariableModel = new JsonVariableModel(JsonUtil.inlineCustom((JsonObject)new Gson().fromJson((Reader)isr, JsonObject.class)), fnCtx, ctx);
                return jsonVariableModel;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ctx.finishLoading();
        }
    }

    static JsonVariableModelPart[] deserializePartArray(JsonObject json, String member, FunctionContext fnCtx, ResourceLoaderContext ctx, boolean require) {
        if (!json.has(member)) {
            if (require) {
                throw new JsonSyntaxException("Did not have '" + member + "' in '" + json + "'");
            }
            return new JsonVariableModelPart[0];
        }
        JsonElement elem = json.get(member);
        if (!elem.isJsonArray()) {
            throw new JsonSyntaxException("Expected an array, got '" + elem + "'");
        }
        JsonArray array = elem.getAsJsonArray();
        JsonVariableModelPart[] to = new JsonVariableModelPart[array.size()];
        for (int i = 0; i < to.length; ++i) {
            to[i] = JsonVariableModelPart.deserializeModelPart(array.get(i), fnCtx, ctx);
        }
        return to;
    }

    public JsonVariableModel(JsonObject obj, FunctionContext fnCtx, ResourceLoaderContext ctx) throws JsonParseException {
        boolean require;
        boolean ambf = false;
        this.textures = new HashMap<String, JsonTexture>();
        this.variables = new LinkedHashMap();
        ArrayList cutout = new ArrayList();
        ArrayList translucent = new ArrayList();
        ArrayList<JsonModelRule> rulesP = new ArrayList<JsonModelRule>();
        if (obj.has("values")) {
            fnCtx = new FunctionContext(fnCtx);
            this.putVariables(JsonUtils.func_152754_s((JsonObject)obj, (String)"values"), fnCtx);
        }
        if (obj.has("parent")) {
            JsonVariableModel parent;
            String parentName = JsonUtils.func_151200_h((JsonObject)obj, (String)"parent");
            parentName = parentName + ".json";
            ResourceLocation from = new ResourceLocation(parentName);
            try {
                parent = JsonVariableModel.deserialize(from, fnCtx, ctx);
            }
            catch (IOException e) {
                throw new JsonParseException("Didn't find the parent '" + parentName + "'!", (Throwable)e);
            }
            ambf = parent.ambientOcclusion;
            if (!JsonUtils.func_151209_a((JsonObject)obj, (String)"textures_reset", (boolean)false)) {
                this.textures.putAll(parent.textures);
            }
            this.variables.putAll(parent.variables);
            if (!JsonUtils.func_151209_a((JsonObject)obj, (String)"cutout_replace", (boolean)false)) {
                Collections.addAll(cutout, parent.cutoutElements);
            }
            if (!JsonUtils.func_151209_a((JsonObject)obj, (String)"translucent_replace", (boolean)false)) {
                Collections.addAll(translucent, parent.translucentElements);
            }
            if (!JsonUtils.func_151209_a((JsonObject)obj, (String)"rules_replace", (boolean)false)) {
                Collections.addAll(rulesP, parent.rules);
            }
        }
        this.ambientOcclusion = JsonUtils.func_151209_a((JsonObject)obj, (String)"ambientocclusion", (boolean)ambf);
        this.deserializeTextures(obj.get("textures"));
        if (obj.has("variables")) {
            fnCtx = new FunctionContext(fnCtx);
            this.putVariables(JsonUtils.func_152754_s((JsonObject)obj, (String)"variables"), fnCtx);
        }
        this.finaliseVariables();
        boolean bl = require = cutout.isEmpty() && translucent.isEmpty();
        if (obj.has("elements")) {
            Collections.addAll(cutout, JsonVariableModel.deserializePartArray(obj, "elements", fnCtx, ctx, require));
        } else {
            Collections.addAll(cutout, JsonVariableModel.deserializePartArray(obj, "cutout", fnCtx, ctx, require));
            Collections.addAll(translucent, JsonVariableModel.deserializePartArray(obj, "translucent", fnCtx, ctx, require));
        }
        this.cutoutElements = cutout.toArray(new JsonVariableModelPart[cutout.size()]);
        this.translucentElements = translucent.toArray(new JsonVariableModelPart[translucent.size()]);
        if (obj.has("rules")) {
            JsonElement elem = obj.get("rules");
            if (!elem.isJsonArray()) {
                throw new JsonSyntaxException("Expected an array, got " + elem + " for 'rules'");
            }
            JsonArray arr = elem.getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                rulesP.add(JsonModelRule.deserialize(arr.get(i), fnCtx, ctx));
            }
        }
        this.rules = rulesP.toArray(new JsonModelRule[rulesP.size()]);
    }

    public JsonVariableModel(JsonVariableModel from) {
        this.textures = new HashMap<String, JsonTexture>(from.textures);
        this.cutoutElements = from.cutoutElements;
        this.translucentElements = from.translucentElements;
        this.rules = from.rules;
        this.ambientOcclusion = from.ambientOcclusion;
    }

    public void onTextureStitchPre(ResourceLocation modelLocation, Set<ResourceLocation> toRegisterSprites) {
        if (ModelHolderRegistry.DEBUG) {
            BCLog.logger.info("[lib.model] The model " + modelLocation + " requires these sprites:");
        }
        ReloadSource srcModel = new ReloadSource(modelLocation, SourceType.MODEL);
        for (Map.Entry<String, JsonTexture> entry : this.textures.entrySet()) {
            JsonTexture lookup = entry.getValue();
            String location = lookup.location;
            if (location.startsWith("#") || location.startsWith("~")) continue;
            ResourceLocation textureLoc = new ResourceLocation(location);
            toRegisterSprites.add(textureLoc);
            ReloadSource srcSprite = new ReloadSource(SpriteUtil.transformLocation(textureLoc), SourceType.SPRITE);
            ReloadManager.INSTANCE.addDependency(srcSprite, srcModel);
            if (!ModelHolderRegistry.DEBUG) continue;
            BCLog.logger.info("[lib.model]  - " + location);
        }
    }

    private void deserializeTextures(JsonElement elem) {
        if (elem == null) {
            return;
        }
        if (!elem.isJsonObject()) {
            throw new JsonSyntaxException("Expected to find an object for 'textures', but found " + elem);
        }
        JsonObject obj = elem.getAsJsonObject();
        for (Map.Entry entry : obj.entrySet()) {
            JsonTexture texture;
            String name = (String)entry.getKey();
            JsonElement tex = (JsonElement)entry.getValue();
            if (tex.isJsonPrimitive() && tex.getAsJsonPrimitive().isString()) {
                String location = tex.getAsString();
                texture = new JsonTexture(location);
            } else if (tex.isJsonObject()) {
                texture = new JsonTexture(tex.getAsJsonObject());
            } else {
                throw new JsonSyntaxException("Expected a string or an object, but got " + tex);
            }
            this.textures.put(name, texture);
        }
    }

    private ModelUtil.TexturedFace lookupTexture(String lookup) {
        JsonTexture tex;
        JsonTexture texture = new JsonTexture(lookup);
        for (int attempts = 0; texture.location.startsWith("#") && attempts < 10 && (tex = this.textures.get(texture.location)) != null; ++attempts) {
            texture = texture.inParent(tex);
        }
        lookup = texture.location;
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(lookup);
        ModelUtil.TexturedFace face = new ModelUtil.TexturedFace();
        face.sprite = sprite;
        face.faceData = texture.faceData;
        return face;
    }

    public MutableQuad[] bakePart(JsonVariableModelPart[] a, ITextureGetter spriteLookup) {
        ArrayList<MutableQuad> list = new ArrayList<MutableQuad>();
        for (JsonVariableModelPart part : a) {
            part.addQuads(list, spriteLookup);
        }
        for (JsonModelRule rule : this.rules) {
            if (!rule.when.evaluate()) continue;
            rule.apply(list);
        }
        return list.toArray(new MutableQuad[list.size()]);
    }

    public MutableQuad[] getCutoutQuads() {
        return this.bakePart(this.cutoutElements, this::lookupTexture);
    }

    public MutableQuad[] getTranslucentQuads() {
        return this.bakePart(this.translucentElements, this::lookupTexture);
    }

    public static interface ITextureGetter {
        public ModelUtil.TexturedFace get(String var1);
    }
}

