/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.fluid;

import buildcraft.api.core.IFluidFilter;
import buildcraft.api.core.IFluidHandlerAdv;
import buildcraft.api.items.FluidItemDrops;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.misc.FluidUtilBC;
import buildcraft.lib.net.PacketBufferBC;
import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TankManager
extends ForwardingList<Tank>
implements IFluidHandlerAdv,
INBTSerializable<NBTTagCompound> {
    private final List<Tank> tanks = new ArrayList<Tank>();

    public TankManager() {
    }

    public TankManager(Tank ... tanks) {
        this.addAll(Arrays.asList(tanks));
    }

    protected List<Tank> delegate() {
        return this.tanks;
    }

    public void addAll(Tank ... values) {
        Collections.addAll(this, values);
    }

    public void addDrops(NonNullList<ItemStack> toDrop) {
        FluidItemDrops.addFluidDrops(toDrop, (IFluidTank[])this.toArray(new Tank[0]));
    }

    public boolean onActivated(EntityPlayer player, BlockPos pos, EnumHand hand) {
        return FluidUtilBC.onTankActivated(player, pos, hand, this);
    }

    private List<Tank> getFillOrderTanks() {
        ArrayList<Tank> list = new ArrayList<Tank>();
        for (Tank t : this.tanks) {
            if (!t.canFill() || t.canDrain()) continue;
            list.add(t);
        }
        for (Tank t : this.tanks) {
            if (!t.canFill() || !t.canDrain()) continue;
            list.add(t);
        }
        return list;
    }

    private List<Tank> getDrainOrderTanks() {
        ArrayList<Tank> list = new ArrayList<Tank>();
        for (Tank t : this.tanks) {
            if (t.canFill() || !t.canDrain()) continue;
            list.add(t);
        }
        for (Tank t : this.tanks) {
            if (!t.canFill() || !t.canDrain()) continue;
            list.add(t);
        }
        return list;
    }

    public int fill(FluidStack resource, boolean doFill) {
        int filled = 0;
        for (Tank tank : this.getFillOrderTanks()) {
            int used = tank.fill(resource, doFill);
            if (used <= 0) continue;
            resource.amount -= used;
            filled += used;
            if (resource.amount > 0) continue;
            return filled;
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        FluidStack draining = new FluidStack(resource, 0);
        int left = resource.amount;
        for (Tank tank : this.getDrainOrderTanks()) {
            FluidStack drained;
            if (!draining.isFluidEqual(tank.getFluid()) || (drained = tank.drain(left, doDrain)) == null || drained.amount <= 0) continue;
            draining.amount += drained.amount;
            left -= drained.amount;
        }
        return draining.amount <= 0 ? null : draining;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack draining = null;
        for (Tank tank : this.getDrainOrderTanks()) {
            FluidStack drained;
            if (draining == null) {
                drained = tank.drain(maxDrain, doDrain);
                if (drained == null || drained.amount <= 0) continue;
                draining = drained;
                maxDrain -= drained.amount;
                continue;
            }
            if (!draining.isFluidEqual(tank.getFluid()) || (drained = tank.drain(maxDrain, doDrain)) == null || drained.amount <= 0) continue;
            draining.amount += drained.amount;
            maxDrain -= drained.amount;
        }
        return draining;
    }

    @Override
    public FluidStack drain(IFluidFilter filter, int maxDrain, boolean doDrain) {
        if (filter == null) {
            return null;
        }
        FluidStack draining = null;
        for (Tank tank : this.getDrainOrderTanks()) {
            FluidStack drained;
            if (!filter.matches(tank.getFluid())) continue;
            if (draining == null) {
                drained = tank.drain(maxDrain, doDrain);
                if (drained == null || drained.amount <= 0) continue;
                draining = drained;
                maxDrain -= drained.amount;
                continue;
            }
            if (!draining.isFluidEqual(tank.getFluid()) || (drained = tank.drain(maxDrain, doDrain)) == null || drained.amount <= 0) continue;
            draining.amount += drained.amount;
            maxDrain -= drained.amount;
        }
        return draining;
    }

    public IFluidTankProperties[] getTankProperties() {
        IFluidTankProperties[] info = new IFluidTankProperties[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            info[i] = ((Tank)this.get(i)).getTankProperties()[0];
        }
        return info;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Tank t : this.tanks) {
            nbt.func_74782_a(t.getTankName(), (NBTBase)t.serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        for (Tank t : this.tanks) {
            t.readFromNBT(nbt.func_74775_l(t.getTankName()));
        }
    }

    public void writeData(PacketBufferBC buffer) {
        for (Tank tank : this.tanks) {
            tank.writeToBuffer(buffer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void readData(PacketBufferBC buffer) {
        for (Tank tank : this.tanks) {
            tank.readFromBuffer(buffer);
        }
    }
}

