/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.json.BuildCraftJsonGui;
import buildcraft.lib.gui.json.ElementType;
import buildcraft.lib.gui.json.JsonGuiElement;
import buildcraft.lib.gui.json.JsonGuiInfo;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.gui.statement.GuiElementStatementParam;
import buildcraft.lib.statement.FullStatement;
import com.google.gson.JsonSyntaxException;

public class ElementTypeStatementParam
extends ElementType {
    public static final String NAME = "buildcraftlib:statement/parameter";
    public static final ElementTypeStatementParam INSTANCE = new ElementTypeStatementParam();

    private ElementTypeStatementParam() {
        super(NAME);
    }

    @Override
    public IGuiElement deserialize0(BuildCraftJsonGui gui, IGuiPosition parent, JsonGuiInfo info, JsonGuiElement json) {
        String source;
        FunctionContext ctx = ElementTypeStatementParam.createContext(json);
        if (!json.properties.containsKey("size[0]")) {
            json.properties.put("size[0]", "18");
        }
        if (!json.properties.containsKey("size[1]")) {
            json.properties.put("size[1]", "18");
        }
        ElementTypeStatementParam.inheritProperty(json, "pos[0]", "area[0]");
        ElementTypeStatementParam.inheritProperty(json, "pos[1]", "area[1]");
        ElementTypeStatementParam.inheritProperty(json, "size[0]", "area[2]");
        ElementTypeStatementParam.inheritProperty(json, "size[1]", "area[3]");
        IGuiArea area = ElementTypeStatementParam.resolveArea(json, "area", parent, ctx);
        if (json.properties.containsKey("source")) {
            source = json.properties.get("source");
        } else {
            source = ElementTypeStatementParam.resolveEquation(json, "source_expression", ctx);
            if (source == null) {
                throw new JsonSyntaxException("Expected either 'source' or 'source_expression' for buildcraftlib:statement/parameter");
            }
        }
        boolean draw = !"false".equals(json.properties.get("draw"));
        int index = ElementTypeStatementParam.resolveEquationInt(json, "index", ctx);
        FullStatement fullStatement = gui.properties.get(source, FullStatement.class);
        IStatementContainer statementContainer = gui.properties.get("statement.container", IStatementContainer.class);
        return new GuiElementStatementParam(gui, area, statementContainer, fullStatement, index, draw);
    }
}

