/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.statement;

import buildcraft.api.statements.IGuiSlot;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.GuiElementSimple;
import buildcraft.lib.gui.IInteractionElement;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.statement.GuiElementStatement;
import buildcraft.lib.gui.statement.GuiElementStatementSource;
import buildcraft.lib.gui.statement.GuiElementStatementVariant;
import buildcraft.lib.misc.data.IReference;
import buildcraft.lib.statement.FullStatement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;

public class GuiElementStatementParam
extends GuiElementSimple
implements IInteractionElement,
IReference<IStatementParameter> {
    private final IStatementContainer container;
    private final FullStatement<?> ref;
    private final int paramIndex;
    private final boolean draw;

    public GuiElementStatementParam(BuildCraftGui gui, IGuiArea element, IStatementContainer container, FullStatement<?> ref, int index, boolean draw) {
        super(gui, element);
        this.container = container;
        this.ref = ref;
        this.paramIndex = index;
        this.draw = draw;
    }

    @Override
    public IStatementParameter get() {
        return this.ref.get(this.paramIndex);
    }

    @Override
    public void set(IStatementParameter to) {
        this.ref.set(this.paramIndex, to);
        this.ref.postSetFromGui(this.paramIndex);
    }

    @Override
    public boolean canSet(IStatementParameter value) {
        return this.ref.canSet(this.paramIndex, value);
    }

    @Override
    public Class<IStatementParameter> getHeldType() {
        return IStatementParameter.class;
    }

    @Override
    public void addToolTips(List<ToolTip> tooltips) {
        IStatementParameter s;
        if (this.contains(this.gui.mouse) && (s = this.get()) != null) {
            tooltips.add(new ToolTip(s.getTooltip()));
        }
    }

    @Override
    public void drawBackground(float partialTicks) {
        if (this.draw) {
            Object slot = this.ref.get();
            int max = slot == null ? 0 : slot.maxParameters();
            double x = this.getX();
            double y = this.getY();
            if (this.paramIndex >= max) {
                GuiElementStatement.SLOT_COLOUR.drawAt(x, y);
                GuiElementStatement.ICON_SLOT_BLOCKED.drawAt(x, y);
                return;
            }
            IStatementParameter statementParameter = this.get();
            GuiElementStatementSource.drawGuiSlot(statementParameter, x, y);
        }
    }

    @Override
    public void onMouseClicked(int button) {
        if (this.ref.canInteract && this.contains(this.gui.mouse) && button == 0) {
            IStatementParameter param = this.get();
            if (param == null) {
                return;
            }
            StatementMouseClick clickEvent = new StatementMouseClick(0, false);
            EntityPlayerSP currentPlayer = Minecraft.func_71410_x().field_71439_g;
            ItemStack heldStack = currentPlayer == null ? ItemStack.field_190927_a : currentPlayer.field_71071_by.func_70445_o();
            IStatementParameter pNew = param.onClick(this.container, (IStatement)this.ref.get(), heldStack, clickEvent);
            if (pNew != null) {
                this.set(pNew);
            } else {
                IGuiSlot[] possible = param.getPossible(this.container);
                if (!param.isPossibleOrdered()) {
                    ArrayList<IGuiSlot> list = new ArrayList<IGuiSlot>();
                    for (IGuiSlot p2 : possible) {
                        if (p2 == null) continue;
                        list.add(p2);
                    }
                    possible = list.toArray(new IStatementParameter[0]);
                }
                this.gui.currentMenu = GuiElementStatementVariant.create(this.gui, this, this, possible);
            }
        }
    }
}

