/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.path;

import buildcraft.lib.misc.WorkerThreadUtil;
import buildcraft.lib.path.MiniChunkGraph;
import buildcraft.lib.path.task.TaskMiniChunkManager;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MiniChunkCache {
    private static Map<Integer, MiniChunkCache> worldCaches = new HashMap<Integer, MiniChunkCache>();
    public final int dimId;
    private final Map<BlockPos, MiniChunkGraph> cache = new ConcurrentHashMap<BlockPos, MiniChunkGraph>();
    final Map<BlockPos, Future<MiniChunkGraph>> tempData = new ConcurrentHashMap<BlockPos, Future<MiniChunkGraph>>();

    private MiniChunkCache(int dimId) {
        this.dimId = dimId;
    }

    public static Future<MiniChunkGraph> requestGraph(World world, BlockPos pos) {
        int dimId = world.field_73011_w.getDimension();
        if (!worldCaches.containsKey(dimId)) {
            worldCaches.put(dimId, new MiniChunkCache(dimId));
        }
        return worldCaches.get(dimId).requestGraphImpl(world, pos);
    }

    public static MiniChunkGraph getGraphIfExists(World world, BlockPos pos) {
        int dimId = world.field_73011_w.getDimension();
        if (!worldCaches.containsKey(dimId)) {
            worldCaches.put(dimId, new MiniChunkCache(dimId));
        }
        return worldCaches.get(dimId).getGraphIfExistsImpl(pos);
    }

    public static MiniChunkGraph requestAndWait(World world, BlockPos pos) {
        try {
            return MiniChunkCache.requestGraph(world, pos).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void putGraph(BlockPos min, MiniChunkGraph graph) {
        this.cache.put(min, graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<MiniChunkGraph> requestGraphImpl(World world, BlockPos pos) {
        BlockPos minPos = MiniChunkCache.convertToMin(pos);
        MiniChunkGraph existing = this.cache.get(pos = minPos);
        if (existing != null) {
            return Futures.immediateCheckedFuture((Object)existing);
        }
        if (!world.func_175667_e(pos)) {
            return Futures.immediateFailedFuture((Throwable)new Throwable("The block " + pos + " is not loaded!"));
        }
        MiniChunkCache miniChunkCache = this;
        synchronized (miniChunkCache) {
            if (this.tempData.containsKey(pos)) {
                return this.tempData.get(pos);
            }
            Consumer<MiniChunkGraph> setter = graph -> this.putGraph(minPos, (MiniChunkGraph)graph);
            TaskMiniChunkManager task = new TaskMiniChunkManager(world, pos, setter);
            Future<MiniChunkGraph> future = WorkerThreadUtil.executeDependantTask(task);
            this.tempData.put(pos, future);
            return future;
        }
    }

    private MiniChunkGraph getGraphIfExistsImpl(BlockPos pos) {
        pos = MiniChunkCache.convertToMin(pos);
        return this.cache.get(pos);
    }

    private static BlockPos convertToMin(BlockPos pos) {
        int x = pos.func_177958_n() / 16 * 16;
        int y = pos.func_177956_o() / 16 * 16;
        int z = pos.func_177952_p() / 16 * 16;
        return new BlockPos(x, y, z);
    }
}

