/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjRedstoneReceiver;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.pipe.IFlowFluid;
import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeEventFluid;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeFaceTex;
import buildcraft.lib.inventory.filter.StackFilter;
import buildcraft.transport.BCTransportConfig;
import buildcraft.transport.pipe.behaviour.PipeBehaviourDirectional;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;

public class PipeBehaviourWood
extends PipeBehaviourDirectional
implements IMjRedstoneReceiver,
IDebuggable {
    private static final PipeFaceTex TEX_CLEAR = PipeFaceTex.get(0);
    private static final PipeFaceTex TEX_FILLED = PipeFaceTex.get(1);
    private final MjCapabilityHelper mjCaps = new MjCapabilityHelper(this);

    public PipeBehaviourWood(IPipe pipe) {
        super(pipe);
    }

    public PipeBehaviourWood(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
    }

    @Override
    public PipeFaceTex getTextureData(EnumFacing face) {
        return face != null && face == this.getCurrentDir() ? TEX_FILLED : TEX_CLEAR;
    }

    @Override
    public boolean canConnect(EnumFacing face, PipeBehaviour other) {
        return !(other instanceof PipeBehaviourWood);
    }

    @Override
    protected boolean canFaceDirection(EnumFacing dir) {
        return dir != null && this.pipe.getConnectedType(dir) == IPipe.ConnectedType.TILE;
    }

    @PipeEventHandler
    public void fluidSideCheck(PipeEventFluid.SideCheck sideCheck) {
        if (this.currentDir.face != null) {
            sideCheck.disallow(this.currentDir.face);
        }
    }

    protected long extract(long power, boolean simulate) {
        if (power > 0L) {
            if (this.pipe.getFlow() instanceof IFlowItems) {
                int extracted;
                IFlowItems flow = (IFlowItems)((Object)this.pipe.getFlow());
                int maxItems = (int)(power / BCTransportConfig.mjPerItem);
                if (maxItems > 0 && (extracted = this.extractItems(flow, this.getCurrentDir(), maxItems, simulate)) > 0) {
                    return power - (long)extracted * BCTransportConfig.mjPerItem;
                }
            } else if (this.pipe.getFlow() instanceof IFlowFluid) {
                FluidStack extracted;
                IFlowFluid flow = (IFlowFluid)((Object)this.pipe.getFlow());
                int maxMillibuckets = (int)(power / BCTransportConfig.mjPerMillibucket);
                if (maxMillibuckets > 0 && (extracted = this.extractFluid(flow, this.getCurrentDir(), maxMillibuckets, simulate)) != null && extracted.amount > 0) {
                    return power - (long)extracted.amount * BCTransportConfig.mjPerMillibucket;
                }
            }
        }
        return power;
    }

    protected int extractItems(IFlowItems flow, EnumFacing dir, int count, boolean simulate) {
        return flow.tryExtractItems(count, dir, null, StackFilter.ALL, simulate);
    }

    @Nullable
    protected FluidStack extractFluid(IFlowFluid flow, EnumFacing dir, int millibuckets, boolean simulate) {
        return flow.tryExtractFluid(millibuckets, dir, null, simulate);
    }

    @Override
    public boolean canConnect(@Nonnull IMjConnector other) {
        return true;
    }

    @Override
    public long getPowerRequested() {
        long power = 512L * MjAPI.MJ;
        return power - this.extract(power, true);
    }

    @Override
    public long receivePower(long microJoules, boolean simulate) {
        return this.extract(microJoules, simulate);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return this.mjCaps.getCapability(capability, facing);
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("Facing = " + (Object)((Object)this.currentDir));
    }
}

