/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting.factories;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;

@MethodsReturnNonnullByDefault
public class UseMetaEffectsIngredientFactory
implements IIngredientFactory {
    public Ingredient parse(JsonContext context, JsonObject json) {
        ItemStack stack = CraftingHelper.getItemStack((JsonObject)json, (JsonContext)context);
        boolean useMeta = JsonUtils.func_151204_g((JsonObject)json, (String)"use_meta") && JsonUtils.func_151212_i((JsonObject)json, (String)"use_meta");
        boolean useEffects = JsonUtils.func_151204_g((JsonObject)json, (String)"use_effects") && JsonUtils.func_151212_i((JsonObject)json, (String)"use_effects");
        float factor = JsonUtils.func_151204_g((JsonObject)json, (String)"duration_factor") ? JsonUtils.func_151217_k((JsonObject)json, (String)"duration_factor") : 1.0f;
        return new UseMetaEffectsIngredient(stack, useMeta, useEffects, factor);
    }

    static class UseMetaEffectsIngredient
    extends Ingredient {
        private final boolean useMeta;
        private final boolean useEffects;
        private final float factor;

        UseMetaEffectsIngredient(ItemStack itemStack, boolean useMeta, boolean useEffects, float factor) {
            super(new ItemStack[]{itemStack});
            this.useMeta = useMeta;
            this.useEffects = useEffects;
            this.factor = factor;
        }

        boolean isUseMeta() {
            return this.useMeta;
        }

        boolean isUseEffects() {
            return this.useEffects;
        }

        public float getFactor() {
            return this.factor;
        }

        public boolean apply(@Nullable ItemStack inventoryStack) {
            if (inventoryStack == null) {
                return false;
            }
            for (ItemStack itemstack : this.func_193365_a()) {
                if (itemstack.func_77973_b() != inventoryStack.func_77973_b()) continue;
                int i = itemstack.func_77960_j();
                if (!this.useMeta && i != Short.MAX_VALUE && i != inventoryStack.func_77960_j()) continue;
                return true;
            }
            return false;
        }
    }
}

