/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.ArrayUtils;
import xreliquary.Reliquary;
import xreliquary.init.ModBlocks;
import xreliquary.items.ItemToggleable;
import xreliquary.items.util.FilteredItemHandlerProvider;
import xreliquary.items.util.FilteredItemStackHandler;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class ItemRendingGale
extends ItemToggleable {
    public ItemRendingGale() {
        super("rending_gale");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @Override
    protected void addMoreInformation(ItemStack rendingGale, @Nullable World world, List<String> tooltip) {
        LanguageHelper.formatTooltip(this.func_77657_g(rendingGale) + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)String.valueOf(this.getFeatherCount(rendingGale, true) / 100)), tooltip);
        if (this.isEnabled(rendingGale)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.RED + Items.field_151008_G.func_77653_i(new ItemStack(Items.field_151008_G)))), tooltip);
        } else {
            LanguageHelper.formatTooltip("tooltip.absorb", tooltip);
        }
    }

    private static int getChargeLimit() {
        return Settings.Items.RendingGale.chargeLimit;
    }

    public static int getChargeCost() {
        return Settings.Items.RendingGale.castChargeCost;
    }

    private static int getFeathersWorth() {
        return Settings.Items.RendingGale.chargeFeatherWorth;
    }

    private static int getBoltChargeCost() {
        return Settings.Items.RendingGale.boltChargeCost;
    }

    private static int getBoltTargetRange() {
        return Settings.Items.RendingGale.blockTargetRange;
    }

    private static int getRadialPushRadius() {
        return Settings.Items.RendingGale.pushPullRadius;
    }

    private static boolean canPushProjectiles() {
        return Settings.Items.RendingGale.canPushProjectiles;
    }

    private void attemptFlight(EntityLivingBase entityLiving) {
        double distance;
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        Vec3d lookVec = player.func_70676_i(0.66f);
        double x = lookVec.field_72450_a;
        double y = lookVec.field_72448_b;
        double z = lookVec.field_72449_c;
        RayTraceResult rayTrace = this.func_77621_a(player.field_70170_p, player, false);
        double slowDownFactor = 1.0;
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && (distance = player.func_180425_c().func_177951_i((Vec3i)rayTrace.func_178782_a())) < 20.0) {
            slowDownFactor = distance / 20.0;
        }
        player.field_70159_w = x * slowDownFactor;
        player.field_70181_x = y * slowDownFactor;
        player.field_70179_y = z * slowDownFactor;
        player.func_70091_d(MoverType.SELF, player.field_70159_w, player.field_70181_x, player.field_70179_y);
        player.field_70143_R = 0.0f;
    }

    public void func_77663_a(ItemStack rendingGale, World world, Entity e, int slotNumber, boolean isSelected) {
        if (world.field_72995_K || !(e instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e;
        if (this.isEnabled(rendingGale) && this.getFeatherCount(rendingGale) + ItemRendingGale.getFeathersWorth() <= ItemRendingGale.getChargeLimit() && InventoryHelper.consumeItem(new ItemStack(Items.field_151008_G), player)) {
            this.setFeatherCount(rendingGale, this.getFeatherCount(rendingGale) + ItemRendingGale.getFeathersWorth(), !player.func_184587_cr());
        }
    }

    public String getMode(ItemStack ist) {
        if (NBTHelper.getString("mode", ist).equals("")) {
            this.setMode(ist, "flight");
        }
        return NBTHelper.getString("mode", ist);
    }

    private void setMode(ItemStack ist, String s) {
        NBTHelper.setString("mode", ist, s);
    }

    private void cycleMode(ItemStack ist, boolean isRaining) {
        if (this.isFlightMode(ist)) {
            this.setMode(ist, "push");
        } else if (this.isPushMode(ist)) {
            this.setMode(ist, "pull");
        } else if (this.isPullMode(ist) && isRaining) {
            this.setMode(ist, "bolt");
        } else {
            this.setMode(ist, "flight");
        }
    }

    private boolean isPullMode(ItemStack ist) {
        return this.getMode(ist).equals("pull");
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack ist) {
        if (entityLiving.field_70170_p.field_72995_K) {
            return false;
        }
        if (!(entityLiving instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (player.func_70093_af()) {
            this.cycleMode(ist, player.field_70170_p.func_72896_J());
            return true;
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FilteredItemHandlerProvider(new int[]{Settings.Items.RendingGale.chargeLimit}, new Item[]{Items.field_151008_G}, new int[]{Settings.Items.RendingGale.chargeFeatherWorth});
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 6000;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack ist) {
        return EnumAction.BLOCK;
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack ist = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            super.func_77659_a(world, player, hand);
        } else {
            player.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
    }

    public void onUsingTick(ItemStack rendingGale, EntityLivingBase entity, int count) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (this.getFeatherCount(rendingGale, player.field_70170_p.field_72995_K) <= 0) {
            player.func_184597_cx();
            return;
        }
        if (this.isBoltMode(rendingGale)) {
            RayTraceResult mop = this.getCycloneBlockTarget(player.field_70170_p, player);
            if (mop != null && count % 8 == 0) {
                int attemptedY = mop.func_178782_a().func_177956_o();
                if (!player.field_70170_p.func_175727_C(mop.func_178782_a())) {
                    ++attemptedY;
                }
                if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_175727_C(new BlockPos(mop.func_178782_a().func_177958_n(), attemptedY, mop.func_178782_a().func_177952_p()))) {
                    player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(player.field_70170_p, (double)mop.func_178782_a().func_177958_n(), (double)mop.func_178782_a().func_177956_o(), (double)mop.func_178782_a().func_177952_p(), false));
                    this.setFeatherCount(rendingGale, Math.max(0, this.getFeatherCount(rendingGale) - ItemRendingGale.getBoltChargeCost()), false);
                }
            }
        } else {
            if (this.isFlightMode(rendingGale)) {
                this.attemptFlight((EntityLivingBase)player);
                this.spawnFlightParticles(player.field_70170_p, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player);
            } else if (this.isPushMode(rendingGale)) {
                this.doRadialPush(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, player, false);
            } else if (this.isPullMode(rendingGale)) {
                this.doRadialPush(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, player, true);
            }
            if (!player.field_70170_p.field_72995_K) {
                this.setFeatherCount(rendingGale, Math.max(0, this.getFeatherCount(rendingGale) - ItemRendingGale.getChargeCost()), false);
            }
        }
    }

    public void func_77615_a(ItemStack rendingGale, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (world.field_72995_K) {
            return;
        }
        NBTHelper.setInteger("count", rendingGale, this.getFeatherCount(rendingGale));
    }

    private boolean isPushMode(ItemStack ist) {
        return this.getMode(ist).equals("push");
    }

    public boolean isFlightMode(ItemStack ist) {
        return this.getMode(ist).equals("flight");
    }

    public boolean hasFlightCharge(EntityPlayer player, ItemStack ist) {
        return this.getFeatherCount(ist) > 0;
    }

    private boolean isBoltMode(ItemStack stack) {
        return this.getMode(stack).equals("bolt");
    }

    private RayTraceResult getCycloneBlockTarget(World world, EntityPlayer player) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + (double)(world.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = ItemRendingGale.getBoltTargetRange();
        Vec3d vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, true, false, false);
    }

    public int getFeatherCount(ItemStack rendingGale) {
        return this.getFeatherCount(rendingGale, false);
    }

    private int getFeatherCount(ItemStack rendingGale, boolean isClient) {
        if (isClient) {
            return NBTHelper.getInteger("count", rendingGale);
        }
        IItemHandler itemHandler = (IItemHandler)rendingGale.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return 0;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.getTotalAmount(0);
    }

    public void setFeatherCount(ItemStack ist, int featherCount, boolean updateNBT) {
        IItemHandler itemHandler = (IItemHandler)ist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        filteredHandler.setTotalAmount(0, featherCount);
        if (updateNBT) {
            NBTHelper.setInteger("count", ist, featherCount);
        }
    }

    public void doRadialPush(World world, double posX, double posY, double posZ, EntityPlayer player, boolean pull) {
        this.spawnRadialHurricaneParticles(world, posX, posY, posZ, player, pull);
        if (world.field_72995_K) {
            return;
        }
        double lowerX = posX - (double)ItemRendingGale.getRadialPushRadius();
        double lowerY = posY - (double)ItemRendingGale.getRadialPushRadius() / 5.0;
        double lowerZ = posZ - (double)ItemRendingGale.getRadialPushRadius();
        double upperX = posX + (double)ItemRendingGale.getRadialPushRadius();
        double upperY = posY + (double)ItemRendingGale.getRadialPushRadius() / 2.0;
        double upperZ = posZ + (double)ItemRendingGale.getRadialPushRadius();
        List entities = world.func_175647_a(Entity.class, new AxisAlignedBB(lowerX, lowerY, lowerZ, upperX, upperY, upperZ), e -> e instanceof EntityLiving || e instanceof IProjectile);
        for (Entity entity : entities) {
            double distance = this.getDistanceToEntity(posX, posY, posZ, entity);
            if (!(distance < (double)ItemRendingGale.getRadialPushRadius()) || this.isBlacklistedEntity(entity) || entity.equals((Object)player)) continue;
            Vec3d pushVector = pull ? new Vec3d(posX - entity.field_70165_t, posY - entity.field_70163_u, posZ - entity.field_70161_v) : new Vec3d(entity.field_70165_t - posX, entity.field_70163_u - posY, entity.field_70161_v - posZ);
            pushVector = pushVector.func_72432_b();
            entity.func_70091_d(MoverType.PLAYER, 0.0, 0.2, 0.0);
            entity.func_70091_d(MoverType.PLAYER, pushVector.field_72450_a, Math.min(pushVector.field_72448_b, 0.1) * 1.5, pushVector.field_72449_c);
        }
    }

    private boolean isBlacklistedEntity(Entity entity) {
        if (EntityList.func_191301_a((Entity)entity) == null) {
            return false;
        }
        String entityName = EntityList.func_191301_a((Entity)entity).toString();
        return this.isBlacklistedLivingEntity(entity, entityName) || Settings.Items.RendingGale.canPushProjectiles && this.isBlacklistedProjectile(entity, entityName);
    }

    private boolean isBlacklistedProjectile(Entity entity, String entityName) {
        return entity instanceof IProjectile && ArrayUtils.contains((Object[])Settings.Items.RendingGale.pushableProjectilesBlacklist, (Object)entityName);
    }

    private boolean isBlacklistedLivingEntity(Entity entity, String entityName) {
        return entity instanceof EntityLiving && ArrayUtils.contains((Object[])Settings.Items.RendingGale.pushableEntitiesBlacklist, (Object)entityName);
    }

    private float getDistanceToEntity(double posX, double posY, double posZ, Entity entityIn) {
        float f = (float)(posX - entityIn.field_70165_t);
        float f1 = (float)(posY - entityIn.field_70163_u);
        float f2 = (float)(posZ - entityIn.field_70161_v);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    private void spawnFlightParticles(World world, double x, double y, double z, EntityPlayer player) {
        Vec3d lookVector = player.func_70040_Z();
        for (int i = 0; i < 8; ++i) {
            float randX = 10.0f * (field_77697_d.nextFloat() - 0.5f);
            float randY = 10.0f * (field_77697_d.nextFloat() - 0.5f);
            float randZ = 10.0f * (field_77697_d.nextFloat() - 0.5f);
            world.func_175688_a(EnumParticleTypes.BLOCK_DUST, x + (double)randX + lookVector.field_72450_a * 20.0, y + (double)randY + lookVector.field_72448_b * 20.0, z + (double)randZ + lookVector.field_72449_c * 20.0, -lookVector.field_72450_a * 5.0, -lookVector.field_72448_b * 5.0, -lookVector.field_72449_c * 5.0, new int[]{ModBlocks.snowStateId});
        }
    }

    private void spawnRadialHurricaneParticles(World world, double posX, double posY, double posZ, EntityPlayer player, boolean pull) {
        for (int i = 0; i < 3; ++i) {
            float randX = world.field_73012_v.nextFloat() - 0.5f;
            float randZ = world.field_73012_v.nextFloat() - 0.5f;
            float motX = randX * 10.0f;
            float motZ = randZ * 10.0f;
            if (pull) {
                randX *= 10.0f;
                randZ *= 10.0f;
                motX *= -1.0f;
                motZ *= -1.0f;
            }
            double posYAdjusted = player == null ? posY : posY + (double)player.func_70047_e() - (double)(player.field_70131_O / 2.0f);
            world.func_175688_a(EnumParticleTypes.BLOCK_DUST, posX + (double)randX, posYAdjusted, posZ + (double)randZ, (double)motX, 0.0, (double)motZ, new int[]{ModBlocks.snowStateId});
        }
    }

    public int getFeatherCountClient(ItemStack rendingGale, EntityPlayer player) {
        int featherCount = this.getFeatherCount(rendingGale, true);
        String mode = this.getMode(rendingGale);
        int ticksInUse = this.func_77626_a(rendingGale) - player.func_184605_cv();
        if (player.func_184587_cr()) {
            featherCount = Math.max(0, featherCount - (mode.equals("bolt") ? ItemRendingGale.getBoltChargeCost() * (ticksInUse / 8) : ItemRendingGale.getChargeCost() * ticksInUse));
        }
        return featherCount;
    }
}

