/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.entities.potion.EntityThrownXRPotion;
import xreliquary.items.ItemBase;
import xreliquary.util.NBTHelper;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.PotionMap;
import xreliquary.util.potions.XRPotionHelper;

public class ItemXRPotion
extends ItemBase {
    public ItemXRPotion() {
        super("potion");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(64);
        this.func_77627_a(true);
    }

    public boolean hasContainerItem(ItemStack ist) {
        return XRPotionHelper.getPotionEffectsFromStack(ist).size() > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack potion, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        XRPotionHelper.addPotionTooltip(potion, tooltip);
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer) || world.field_72995_K) {
            return stack;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        for (PotionEffect effect : XRPotionHelper.getPotionEffectsFromStack(stack)) {
            if (effect == null) continue;
            player.func_70690_d(new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c(), false, false));
        }
        if (!player.field_71075_bZ.field_75098_d) {
            ItemStack emptyVial = new ItemStack((Item)this);
            emptyVial.func_77982_d(new NBTTagCompound());
            if (stack.func_190916_E() <= 0) {
                return emptyVial;
            }
            player.field_71071_by.func_70441_a(emptyVial);
        }
        return stack;
    }

    public boolean isSplash(ItemStack ist) {
        return NBTHelper.getBoolean("splash", ist);
    }

    public boolean isLingering(ItemStack ist) {
        return NBTHelper.getBoolean("lingering", ist);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 16;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)new ItemStack((Item)this));
        ArrayList<ItemStack> splashPotions = new ArrayList<ItemStack>();
        ArrayList<ItemStack> lingeringPotions = new ArrayList<ItemStack>();
        for (PotionEssence essence : PotionMap.uniquePotions) {
            ItemStack potion = new ItemStack((Item)this, 1);
            XRPotionHelper.addPotionEffectsToStack(potion, essence.getEffects());
            NBTHelper.setBoolean("hasPotion", potion, true);
            ItemStack splashPotion = potion.func_77946_l();
            NBTHelper.setBoolean("splash", splashPotion, true);
            ItemStack lingeringPotion = potion.func_77946_l();
            NBTHelper.setBoolean("lingering", lingeringPotion, true);
            subItems.add((Object)potion);
            splashPotions.add(splashPotion);
            lingeringPotions.add(lingeringPotion);
        }
        subItems.addAll(splashPotions);
        subItems.addAll(lingeringPotions);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack ist) {
        if (!this.isSplash(ist) && XRPotionHelper.getPotionEffectsFromStack(ist).size() > 0) {
            return EnumAction.DRINK;
        }
        return EnumAction.NONE;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        if (!stack.func_77942_o() || stack.func_77978_p().func_82582_d()) {
            return "item.potion_empty";
        }
        if (this.isLingering(stack)) {
            return "item.potion_lingering";
        }
        if (this.isSplash(stack)) {
            return "item.potion_splash";
        }
        return super.func_77667_c(stack);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.isSplash(stack) && !this.isLingering(stack)) {
            if (XRPotionHelper.getPotionEffectsFromStack(stack).size() > 0) {
                player.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        EntityThrownXRPotion e = new EntityThrownXRPotion(world, (EntityLivingBase)player, stack);
        e.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, -20.0f, 0.5f, 1.0f);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        world.func_72838_d((Entity)e);
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }
}

