/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.reference;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xreliquary.client.gui.hud.HUDPosition;
import xreliquary.util.potions.PotionMap;

@Config(modid="xreliquary")
public class Settings {
    private static final int ITEM_CAP = 9999;
    private static final int CLEAN_SHORT_MAX = 30000;
    private static final int CLEAN_INT_MAX = 2000000000;
    @Config.Name(value="chest_loot_enabled")
    @Config.Comment(value={"Determines whether Reliquary items will be generated in chest loot (mostly mob drops, very rarely some lower level items)"})
    @Config.RequiresMcRestart
    public static boolean chestLootEnabled = true;
    @Config.Name(value="waila_shift_for_info")
    @Config.Comment(value={"Whether player has to sneak to see additional info in waila"})
    public static boolean wailaShiftForInfo = false;
    @Config.Name(value="mob_drop_crafting_recipes_enabled")
    @Config.Comment(value={"Determines wheter Reliquary mob drops have crafting recipes"})
    public static boolean dropCraftingRecipesEnabled = false;
    @Config.Name(value="mob_drops_enabled")
    @Config.Comment(value={"Whether mobs drop the Reliquary mob drops. This won't remove mob drop items from registry and replace them with something else, but allows to turn off the additional drops when mobs are killed by player. If this is turned off the mob drop crafting recipes turned on by the other setting can be used."})
    @Config.RequiresMcRestart
    public static boolean mobDropsEnabled = true;
    @Config.Name(value="disable")
    @Config.Comment(value={"Disable sections of the mod"})
    public static final DisableSettings Disable = new DisableSettings();
    @Config.Name(value="potions")
    @Config.Comment(value={"Potions related settings"})
    public static final PotionSettings Potions = new PotionSettings();
    @Config.Name(value="hud_positions")
    @Config.Comment(value={"Position of mode and/or item display on the screen - used by some of the tools and weapons."})
    public static final HudPos HudPositions = new HudPos();
    @Config.Name(value="item_settings")
    public static final ItemSettings Items = new ItemSettings();
    @Config.Name(value="block_settings")
    public static final BlockSettings Blocks = new BlockSettings();

    public static class BlockSettings {
        @Config.Name(value="altar")
        @Config.Comment(value={"Altar of Light settings"})
        public final AltarSettings Altar = new AltarSettings();
        @Config.Name(value="apothecary_cauldron")
        @Config.Comment(value={"Apothecary Cauldron settings"})
        public final ApothecaryCauldronSettings ApothecaryCauldron = new ApothecaryCauldronSettings();
        @Config.Name(value="fertile_lilypad")
        @Config.Comment(value={"Lilypad of Fertility settings"})
        public final FertileLilypadSettings FertileLilypad = new FertileLilypadSettings();
        @Config.Name(value="interdiction_torch")
        @Config.Comment(value={"Interdiction Torch settings"})
        public final InterdictionTorchSettings InterdictionTorch = new InterdictionTorchSettings();
        @Config.Name(value="pedestal")
        @Config.Comment(value={"Pedestal related settings"})
        public final PedestalSettings Pedestal = new PedestalSettings();

        public class PedestalSettings {
            @Config.Name(value="melee_wrapper_range")
            @Config.Comment(value={"Range of the melee weapons in which these will attack when in pedestal"})
            @Config.RangeInt(min=1, max=10)
            public int meleeWrapperRange = 5;
            @Config.Name(value="melee_wrapper_cooldown")
            @Config.Comment(value={"How long it takes after a melee weapon swing before it can swing again (in ticks)"})
            @Config.RangeInt(min=1, max=200)
            public byte meleeWrapperCooldown = (byte)5;
            @Config.Name(value="bucket_wrapper_range")
            @Config.Comment(value={"Range at which bucket will pickup liquid blocks or milk cows"})
            @Config.RangeInt(min=1, max=10)
            public int bucketWrapperRange = 4;
            @Config.Name(value="bucket_wrapper_cooldown")
            @Config.Comment(value={"How long it takes in between bucket actions (in ticks)"})
            @Config.RangeInt(min=1, max=200)
            public byte bucketWrapperCooldown = (byte)40;
            @Config.Name(value="shears_wrapper_range")
            @Config.Comment(value={"How long it takes between shearing actions (in ticks)"})
            @Config.RangeInt(min=1, max=10)
            public int shearsWrapperRange = 4;
            @Config.Name(value="shears_wrapper_cooldown")
            @Config.Comment(value={"Range at which shears will shear sheep or shearable blocks"})
            @Config.RangeInt(min=1, max=200)
            public byte shearsWrapperCooldown = (byte)10;
            @Config.Name(value="redstone_wrapper_range")
            @Config.Comment(value={"Range at which pedestal will get turned on if either redstone block gets put in or redstone dust and transmitting pedestal is powered"})
            @Config.RangeInt(min=1, max=200)
            public int redstoneWrapperRange = 10;
            @Config.Name(value="fishing_wrapper_success_rate")
            @Config.Comment(value={"Success rate of fishing in percent. When unsuccessful it will pull the hook too late to catch a fish."})
            @Config.RangeInt(min=0, max=100)
            public int fishingWrapperSuccessRate = 80;
            @Config.Name(value="fishing_wrapper_retract_delay")
            @Config.Comment(value={"Delay in seconds before it would start fishing again after retracting the hook."})
            @Config.RangeInt(min=1, max=20)
            public int fishingWrapperRetractDelay = 2;
        }

        public class InterdictionTorchSettings {
            @Config.Name(value="push_radius")
            @Config.Comment(value={"Radius in which the torch can push out mobs"})
            @Config.RangeInt(min=1, max=15)
            public int pushRadius = 5;
            @Config.Name(value="can_push_projectiles")
            @Config.Comment(value={"Whether the torch can push projectiles"})
            public boolean canPushProjectiles = false;
            @Config.Name(value="pushable_entities_blacklist")
            @Config.Comment(value={"List of entities that are banned from being pushed by the torch"})
            public String[] pushableEntitiesBlacklist = new String[0];
            @Config.Name(value="pushable_projectiles_blacklist")
            @Config.Comment(value={"List of projectiles that are banned from being pushed by the torch"})
            public String[] pushableProjectilesBlacklist = new String[0];
        }

        public class FertileLilypadSettings {
            @Config.Name(value="seconds_between_growth_ticks")
            @Config.Comment(value={"Interval in seconds at which the lilypad causes growth tick updates"})
            @Config.RangeInt(min=1, max=150)
            public int secondsBetweenGrowthTicks = 10;
            @Config.Name(value="tile_range")
            @Config.Comment(value={"Radius in which lilypad causes growh ticks"})
            @Config.RangeInt(min=1, max=15)
            public int tileRange = 4;
            @Config.Name(value="full_potency_range")
            @Config.Comment(value={"Radius around lilypad where the growth ticks occur the most often"})
            @Config.RangeInt(min=1, max=15)
            public int fullPotencyRange = 1;
        }

        public class ApothecaryCauldronSettings {
            @Config.Name(value="redstone_limit")
            @Config.Comment(value={"Limit of redstone that can be used in cauldron to make potion last longer"})
            @Config.RangeInt(min=0, max=5)
            public int redstoneLimit = 3;
            @Config.Name(value="cook_time")
            @Config.Comment(value={"Time it takes to cook potion"})
            @Config.RangeInt(min=20, max=32000)
            public int cookTime = 160;
            @Config.Name(value="heat_sources")
            @Config.Comment(value={"List of acceptable heat sources"})
            public String[] heatSources = new String[0];
            @Config.Name(value="glowstone_limit")
            @Config.Comment(value={"Limit of glowstone that can be used in cauldron to make potion more potent"})
            @Config.RangeInt(min=0, max=4)
            public int glowstoneLimit = 2;
        }

        public class AltarSettings {
            @Config.Name(value="redstone_cost")
            @Config.Comment(value={"Number of redstone it costs to activate altar"})
            @Config.RangeInt(min=0, max=10)
            public int redstoneCost = 3;
            @Config.Name(value="time_in_minutes")
            @Config.Comment(value={"Time in minutes it takes for the altar to create glowstone block"})
            @Config.RangeInt(min=0, max=60)
            public int timeInMinutes = 20;
            @Config.Name(value="maximum_time_variance_in_minutes")
            @Config.Comment(value={"Maximum time variance in minutes. A random part of it gets added to the Time in minutes."})
            @Config.RangeInt(min=0, max=15)
            public int maximumTimeVarianceInMinutes = 5;
            @Config.Name(value="output_light_level_while_active")
            @Config.Comment(value={"Light level that the altar outputs while active"})
            @Config.RangeInt(min=16, max=0)
            public int outputLightLevelWhileActive = 16;
        }
    }

    public static class ItemSettings {
        @Config.Name(value="alkahestry_tome")
        @Config.Comment(value={"Alkahestry Tome settings"})
        public final AlkahestryTomeSettings AlkahestryTome = new AlkahestryTomeSettings();
        @Config.Name(value="angelic_feather")
        @Config.Comment(value={"Angelic Feather settings"})
        public final AngelicFeatherSettings AngelicFeather = new AngelicFeatherSettings();
        @Config.Name(value="angelheart_vial")
        @Config.Comment(value={"Angelheart Vial settings"})
        public final AngelHeartVialSettings AngelHeartVial = new AngelHeartVialSettings();
        @Config.Name(value="destruction_catalyst")
        @Config.Comment(value={"Destruction Catalyst settings"})
        public final DestructionCatalystSettings DestructionCatalyst = new DestructionCatalystSettings();
        @Config.Name(value="emperor_chalice")
        @Config.Comment(value={"Emperor Chalice settings"})
        public final EmperorChaliceSettings EmperorChalice = new EmperorChaliceSettings();
        @Config.Name(value="ender_staff")
        @Config.Comment(value={"Ender Staff settings"})
        public final EnderStaffSettings EnderStaff = new EnderStaffSettings();
        @Config.Name(value="fortune_coin")
        @Config.Comment(value={"Fortune Coin settings"})
        public final FortuneCoinSettings FortuneCoin = new FortuneCoinSettings();
        @Config.Name(value="glacial_staff")
        @Config.Comment(value={"Glacial Staff settings"})
        public final GlacialStaffSettings GlacialStaff = new GlacialStaffSettings();
        @Config.Name(value="harvest_rod")
        @Config.Comment(value={"Harvest Rod settings"})
        public final HarvestRodSettings HarvestRod = new HarvestRodSettings();
        @Config.Name(value="hero_medallion")
        @Config.Comment(value={"Hero Medallion settings"})
        public final HeroMedallionSettings HeroMedallion = new HeroMedallionSettings();
        @Config.Name(value="ice_magus_rod")
        @Config.Comment(value={"Ice Magus Rod settings"})
        public final IceMagusRodSettings IceMagusRod = new IceMagusRodSettings();
        @Config.Name(value="infernal_chalice")
        @Config.Comment(value={"Infernal Chalice settings"})
        public final InfernalChaliceSettings InfernalChalice = new InfernalChaliceSettings();
        @Config.Name(value="infernal_claws")
        @Config.Comment(value={"Infernal Chalice settings"})
        public final InfernalClawsSettings InfernalClaws = new InfernalClawsSettings();
        @Config.Name(value="infernal_tear")
        @Config.Comment(value={"Infernal Tear settings"})
        public final InfernalTearSettings InfernalTear = new InfernalTearSettings();
        @Config.Name(value="kraken_shell")
        @Config.Comment(value={"Kraken Shell settings"})
        public final KrakenShellSettings KrakenShell = new KrakenShellSettings();
        @Config.Name(value="lantern_of_paranoia")
        @Config.Comment(value={"Lantern of Paranoia settings"})
        public final LanternOfParanoiaSettings LanternOfParanoia = new LanternOfParanoiaSettings();
        @Config.Name(value="midas_touchstone")
        @Config.Comment(value={"Midas Touchstone settings"})
        public final MidasTouchstoneSettings MidasTouchstone = new MidasTouchstoneSettings();
        @Config.Name(value="mob_charm")
        @Config.Comment(value={"Mob Charm settings"})
        public final MobCharmSettings MobCharm = new MobCharmSettings();
        @Config.Name(value="phoenix_down")
        @Config.Comment(value={"Phoenix Down settings"})
        public final PhoenixDownSettings PhoenixDown = new PhoenixDownSettings();
        @Config.Name(value="pyromancer_staff")
        @Config.Comment(value={"Pyromancer Staff settings"})
        public final PyromancerStaffSettings PyromancerStaff = new PyromancerStaffSettings();
        @Config.Name(value="rending_gale")
        @Config.Comment(value={"Rending Gale settings"})
        public final RendingGaleSettings RendingGale = new RendingGaleSettings();
        @Config.Name(value="rod_of_lyssa")
        @Config.Comment(value={"Rod of Lyssa settings"})
        public final RodOfLyssaSettings RodOfLyssa = new RodOfLyssaSettings();
        @Config.Name(value="seeker_shot")
        @Config.Comment(value={"Seeker Shot settings"})
        public final SeekerShotSettings SeekerShot = new SeekerShotSettings();
        @Config.Name(value="sojourner_staff")
        @Config.Comment(value={"Sojourner Staff settings"})
        public final SojournerStaffSettings SojournerStaff = new SojournerStaffSettings();
        @Config.Name(value="twilight_cloak")
        @Config.Comment(value={"Twilight Cloak settings"})
        public final TwilightCloakSettings TwilightCloak = new TwilightCloakSettings();
        @Config.Name(value="void_tear")
        @Config.Comment(value={"Void Tear settings"})
        public final VoidTearSettings VoidTear = new VoidTearSettings();

        public class VoidTearSettings {
            @Config.Name(value="item_limit")
            @Config.Comment(value={"Number of items the tear can hold of the item type it is set to"})
            @Config.RangeInt(min=0, max=2000000000)
            public int itemLimit = 2000000000;
            @Config.Name(value="absorb_when_created")
            @Config.Comment(value={"Whether the void tear starts absorbing immediately after it is set to item type"})
            public boolean absorbWhenCreated = true;
        }

        public class TwilightCloakSettings {
            @Config.Name(value="max_light_level")
            @Config.Comment(value={"Maximum light level at which the player is still invisible to the mobs"})
            @Config.RangeInt(min=0, max=15)
            public int maxLightLevel = 4;
        }

        public class SojournerStaffSettings {
            @Config.Name(value="torches")
            @Config.Comment(value={"List of torches that are supported by the staff in addition to the default minecraft torch"})
            public String[] torches = new String[]{"minecraft:torch"};
            @Config.Name(value="max_capacity_per_item_type")
            @Config.Comment(value={"Number of items the staff can store per item type"})
            @Config.RangeInt(min=1, max=9999)
            public int maxCapacityPerItemType = 1500;
            @Config.Name(value="max_range")
            @Config.Comment(value={"Maximum range at which torches can be placed"})
            @Config.RangeInt(min=1, max=30)
            public int maxRange = 30;
            @Config.Name(value="tile_per_cost_multiplier")
            @Config.Comment(value={"Distance after which there is an additional cost for torch placement. The additional cost is the number of times this distance fits in the distance at which the torch is being placed."})
            @Config.RangeInt(min=6, max=30)
            public int tilePerCostMultiplier = 6;
        }

        public class SeekerShotSettings {
            @Config.Name(value="huntable_entities_blacklist")
            @Config.Comment(value={"Entities that are banned from being tracked by seeker shot"})
            public String[] huntableEntitiesBlacklist = new String[0];
        }

        public class RodOfLyssaSettings {
            @Config.Name(value="use_leveled_failure_rate")
            @Config.Comment(value={"Whether level influences stealing failure rate of the rod"})
            public boolean useLeveledFailureRate = true;
            @Config.Name(value="level_cap_for_leveled_formula")
            @Config.Comment(value={"The experience level cap after which the failure rate is at a minimum and doesn't get better"})
            @Config.RangeInt(min=1, max=900)
            public int levelCapForLeveledFormula = 100;
            @Config.Name(value="flat_steal_failure_percent_rate")
            @Config.Comment(value={"The flat failure rate in case failure rate isn't influenced by player's level"})
            @Config.RangeInt(min=0, max=100)
            public int flatStealFailurePercentRate = 10;
            @Config.Name(value="steal_from_vacant_slots")
            @Config.Comment(value={"If set to false it goes through additional 4 accessible slots and looks for items in case the one selected randomly was empty"})
            public boolean stealFromVacantSlots = true;
            @Config.Name(value="fail_steal_from_vacant_slots")
            @Config.Comment(value={"Whether stealing from an empty slot triggers failure even if otherwise it would be successful"})
            public boolean failStealFromVacantSlots = false;
            @Config.Name(value="anger_on_steal_failure")
            @Config.Comment(value={"Whether entities get angry at player if stealing fails"})
            public boolean angerOnStealFailure = true;
            @Config.Name(value="steal_from_players")
            @Config.Comment(value={"Allows switching stealing from player on and off"})
            public boolean stealFromPlayers = true;
        }

        public class RendingGaleSettings {
            @Config.Name(value="charge_limit")
            @Config.Comment(value={"Number of feathers the rending gale can hold"})
            @Config.RangeInt(min=0, max=2000000000)
            public int chargeLimit = 30000;
            @Config.Name(value="cast_charge_cost")
            @Config.Comment(value={"Number of feathers used when the rending gale is cast in flight mode"})
            @Config.RangeInt(min=0, max=3)
            public int castChargeCost = 1;
            @Config.Name(value="bolt_charge_cost")
            @Config.Comment(value={"Number of feathers used to cast a lightning bolt"})
            @Config.RangeInt(min=0, max=250)
            public int boltChargeCost = 100;
            @Config.Name(value="charge_feather_worth")
            @Config.Comment(value={"Number of feathers that get added to the rending gale per one that's consumed from player's inventory"})
            @Config.RangeInt(min=1, max=250)
            public int chargeFeatherWorth = 100;
            @Config.Name(value="block_target_range")
            @Config.Comment(value={"How far a lightning block can be cast"})
            @Config.RangeInt(min=5, max=15)
            public int blockTargetRange = 12;
            @Config.Name(value="push_pull_radius")
            @Config.Comment(value={"Radius in which entities can be pushed/pulled"})
            @Config.RangeInt(min=1, max=20)
            public int pushPullRadius = 10;
            @Config.Name(value="can_push_projectiles")
            @Config.Comment(value={"Whether the rending gale can push projectiles"})
            public boolean canPushProjectiles = false;
            @Config.Name(value="pedestal_flight_range")
            @Config.Comment(value={"Range from pedestal at which players will get buffed with flight"})
            @Config.RangeInt(min=10, max=100)
            public int pedestalFlightRange = 30;
            @Config.Name(value="pedestal_cost_per_second")
            @Config.Comment(value={"Cost per second of buffing players with flight"})
            @Config.RangeInt(min=1, max=20)
            public int pedestalCostPerSecond = 5;
            @Config.Name(value="pushable_entities_blacklist")
            @Config.Comment(value={"List of entities that are banned from being pushed by the Rending Gale"})
            public String[] pushableEntitiesBlacklist = new String[0];
            @Config.Name(value="pushable_projectiles_blacklist")
            @Config.Comment(value={"List of projectiles that are banned from being pushed by the Rending Gale"})
            public String[] pushableProjectilesBlacklist = new String[0];
        }

        public class PyromancerStaffSettings {
            @Config.Name(value="fire_charge_limit")
            @Config.Comment(value={"Number of fire charges the staff can hold"})
            @Config.RangeInt(min=0, max=9999)
            public int fireChargeLimit = 250;
            @Config.Name(value="fire_charge_cost")
            @Config.Comment(value={"Number of fire charges used when the staff is fired"})
            @Config.RangeInt(min=0, max=3)
            public int fireChargeCost = 1;
            @Config.Name(value="fire_charge_worth")
            @Config.Comment(value={"Number of fire charges that get added to the staff per one that's consumed from player's inventory"})
            @Config.RangeInt(min=0, max=3)
            public int fireChargeWorth = 1;
            @Config.Name(value="ghast_absorb_worth")
            @Config.Comment(value={"Number of fire charges added to the staff per one that was shot by ghast and gets absorbed by the staff"})
            @Config.RangeInt(min=0, max=3)
            public int ghastAbsorbWorth = 1;
            @Config.Name(value="blaze_powder_limit")
            @Config.Comment(value={"Number of blaze powder the staff can hold"})
            @Config.RangeInt(min=0, max=9999)
            public int blazePowderLimit = 250;
            @Config.Name(value="blaze_powder_cost")
            @Config.Comment(value={"Number of blaze powder used when staff is fired"})
            @Config.RangeInt(min=0, max=3)
            public int blazePowderCost = 1;
            @Config.Name(value="blaze_powder_worth")
            @Config.Comment(value={"Number of blaze powder that gets added to the staff per one that's consumed from player's inventory"})
            @Config.RangeInt(min=0, max=3)
            public int blazePowderWorth = 1;
            @Config.Name(value="blaze_absorb_worth")
            @Config.Comment(value={"Number of blaze powder added to the staff per one fireball that was shot by blaze and gets absorbed by the staff"})
            @Config.RangeInt(min=0, max=3)
            public int blazeAbsorbWorth = 1;
        }

        public class PhoenixDownSettings {
            @Config.Name(value="hunger_cost_percent")
            @Config.Comment(value={"Percent hunger used to heal player per 1 damage that would be taken otherwise"})
            @Config.RangeInt(min=0, max=50)
            public int hungerCostPercent = 25;
            @Config.Name(value="leaping_potency")
            @Config.Comment(value={"Potency of the leaping effect"})
            @Config.RangeInt(min=0, max=5)
            public int leapingPotency = 1;
            @Config.Name(value="heal_percentage_of_max_life")
            @Config.Comment(value={"Percent of life that gets healed when the player would die"})
            @Config.RangeInt(min=0, max=100)
            public int healPercentageOfMaxLife = 100;
            @Config.Name(value="remove_negative_status")
            @Config.Comment(value={"Whether the player gets negative statuses removed when they were saved by Phoenix Down"})
            public boolean removeNegativeStatus = true;
            @Config.Name(value="give_temporary_damage_resistance")
            @Config.Comment(value={"Whether to give temporary damage resistance when the player would die"})
            public boolean giveTemporaryDamageResistance = true;
            @Config.Name(value="give_temporary_regeneration")
            @Config.Comment(value={"Whether to give temporary regeneration when the player would die"})
            public boolean giveTemporaryRegeneration = true;
            @Config.Name(value="give_temporary_fire_resistance_if_fire_damage_killed_you")
            @Config.Comment(value={"Whether to give temporary fire resistance when the player would die. Applies only when the player is being hurt by fire damage."})
            public boolean giveTemporaryFireResistanceIfFireDamageKilledYou = true;
            @Config.Name(value="give_temporary_water_breathing_if_drowning_killed_you")
            @Config.Comment(value={"Whether to give temporary damage resistance when the player would die. Applies only when the player is drowning."})
            public boolean giveTemporaryWaterBreathingIfDrowningKilledYou = true;
        }

        public class MobCharmSettings {
            @Config.Name(value="durability")
            @Config.Comment(value={"Total durability of Mob Charm"})
            @Config.RangeInt(min=20, max=1000)
            public int durability = 80;
            @Config.Name(value="damage_per_kill")
            @Config.Comment(value={"Damage that Mob Charm takes when player kills mob it protects them from"})
            @Config.RangeInt(min=0, max=40)
            public int damagePerKill = 1;
            @Config.Name(value="drop_durability_repair")
            @Config.Comment(value={"Sets how much durability of Mob Charm gets repaired per special drop"})
            @Config.RangeInt(min=1, max=200)
            public int dropDurabilityRepair = 20;
            @Config.Name(value="max_charms_to_display")
            @Config.Comment(value={"Maximum charms that will get displayed in HUD"})
            @Config.RangeInt(min=1, max=20)
            public int maxCharmsToDisplay = 6;
            @Config.Name(value="pedestal_range")
            @Config.Comment(value={"Range in which mob charm or belt in pedestal will keep monsters from attacking players"})
            @Config.RangeInt(min=10, max=100)
            public int pedestalRange = 21;
            @Config.Name(value="keep_almost_destroyed_displayed")
            @Config.Comment(value={"Determines if almost destroyed charms stay displayed in the hud"})
            public boolean keepAlmostDestroyedDisplayed = true;
        }

        public class MidasTouchstoneSettings {
            @Config.Name(value="gold_items")
            @Config.Comment(value={"Gold items that can be repaired by the touchstone"})
            public String[] goldItems = new String[0];
            @Config.Name(value="glowstone_cost")
            @Config.Comment(value={"Number of glowstone that the repair costs"})
            @Config.RangeInt(min=0, max=3)
            public int glowstoneCost = 1;
            @Config.Name(value="glowstone_worth")
            @Config.Comment(value={"Number of glowstone that gets added to the touchstone per one in player's inventory"})
            @Config.RangeInt(min=0, max=12)
            public int glowstoneWorth = 4;
            @Config.Name(value="glowstone_limit")
            @Config.Comment(value={"Number of glowstone the touchstone can hold"})
            @Config.RangeInt(min=0, max=9999)
            public int glowstoneLimit = 250;
        }

        public class LanternOfParanoiaSettings {
            @Config.Name(value="min_light_level")
            @Config.Comment(value={"Minimum light level below which the lantern will place torches"})
            @Config.RangeInt(min=0, max=15)
            public int minLightLevel = 8;
            @Config.Name(value="placement_scan_radius")
            @Config.Comment(value={"Radius in which the lantern checks for light levels and places torches"})
            @Config.RangeInt(min=1, max=15)
            public int placementScanRadius = 6;
        }

        public class KrakenShellSettings {
            @Config.Name(value="hunger_cost_percent")
            @Config.Comment(value={"Percent hunger used to heal player per 1 damage that would be taken otherwise."})
            @Config.RangeInt(min=0, max=50)
            public int hungerCostPercent = 25;
        }

        public class InfernalTearSettings {
            @Config.Name(value="absorb_when_created")
            @Config.Comment(value={"Whether the infernal tear starts absorbing immediately after it is set to item type"})
            public boolean absorbWhenCreated = false;
        }

        public class InfernalClawsSettings {
            @Config.Name(value="hunger_cost_percent")
            @Config.Comment(value={"Percent hunger used to heal player per 1 damage that would be taken otherwise."})
            @Config.RangeInt(min=0, max=30)
            public int hungerCostPercent = 5;
        }

        public class InfernalChaliceSettings {
            @Config.Name(value="hunger_cost_percent")
            @Config.Comment(value={"Percent hunger used to heal player per 1 damage that would be taken otherwise."})
            @Config.RangeInt(min=0, max=10)
            public int hungerCostPercent = 1;
            @Config.Name(value="fluid_limit")
            @Config.Comment(value={"Millibuckets of lava that the chalice can hold"})
            @Config.RangeInt(min=0, max=2000000000)
            public int fluidLimit = 500000;
        }

        public class IceMagusRodSettings {
            @Config.Name(value="snowball_limit")
            @Config.Comment(value={"Number of snowballs the rod can hold"})
            @Config.RangeInt(min=0, max=9999)
            public int snowballLimit = 250;
            @Config.Name(value="snowball_cost")
            @Config.Comment(value={"Number of snowballs it costs when the rod is used"})
            @Config.RangeInt(min=0, max=3)
            public int snowballCost = 1;
            @Config.Name(value="snowball_worth")
            @Config.Comment(value={"Number of snowballs that get added to the rod per one that's consumed from player's inventory"})
            @Config.RangeInt(min=0, max=3)
            public int snowballWorth = 1;
            @Config.Name(value="snowball_damage")
            @Config.Comment(value={"The damage that snowballs cause"})
            @Config.RangeInt(min=0, max=4)
            public int snowballDamage = 2;
            @Config.Name(value="snowball_damage_bonus_fire_immune")
            @Config.Comment(value={"Damage bonus against fire immune mobs"})
            @Config.RangeInt(min=0, max=4)
            public int snowballDamageBonusFireImmune = 2;
            @Config.Name(value="snowball_damage_bonus_blaze")
            @Config.Comment(value={"Damage bonus against blaze"})
            @Config.RangeInt(min=0, max=8)
            public int snowballDamageBonusBlaze = 4;
        }

        public class HeroMedallionSettings {
            @Config.Name(value="experience_level_maximum")
            @Config.Comment(value={"A player's experience level at which pulling from the medallion to player will stop"})
            @Config.RangeInt(min=0, max=1000)
            public int experienceLevelMaximum = 200;
            @Config.Name(value="experience_level_minimum")
            @Config.Comment(value={"A player's experience level at which the medallion will stop pulling from the player"})
            @Config.RangeInt(min=0, max=30)
            public int experienceLevelMinimum = 0;
            @Config.Name(value="experience_limit")
            @Config.Comment(value={"Experience level that the medallion can hold"})
            @Config.RangeInt(min=0, max=2000000000)
            public int experienceLimit = 2000000000;
            @Config.Name(value="experience_drop")
            @Config.Comment(value={"How much experience gets dropped on ground when hero's medallion is right clicked on it (9 is the first level of player xp)"})
            @Config.RangeInt(min=1, max=100)
            public int experienceDrop = 9;
            @Config.Name(value="pedestal_cooldown")
            @Config.Comment(value={"Cooldown between hero medallion tries to fix mending items in nearby pedestals"})
            @Config.RangeInt(min=1, max=100)
            public int pedestalCoolDown = 20;
            @Config.Name(value="pedestal_range")
            @Config.Comment(value={"Range in which pedestals are checked for items with mending enchant that need fixing"})
            @Config.RangeInt(min=1, max=20)
            public int pedestalRange = 5;
            @Config.Name(value="pedestal_repair_step_xp")
            @Config.Comment(value={"Maximum amount of xp that is used each time medallion repairs items"})
            @Config.RangeInt(min=1, max=20)
            public int pedestalRepairStepXP = 5;
        }

        public class HarvestRodSettings {
            @Config.Name(value="bonemeal_limit")
            @Config.Comment(value={"Number of bonemeal the rod can hold"})
            @Config.RangeInt(min=0, max=9999)
            public int boneMealLimit = 250;
            @Config.Name(value="bonemeal_cost")
            @Config.Comment(value={"Number of bonemeal consumed per use"})
            @Config.RangeInt(min=0, max=3)
            public int boneMealCost = 1;
            @Config.Name(value="bonemeal_worth")
            @Config.Comment(value={"Number of bonemeal that gets added to the rod per one that's consumed from player's inventory"})
            @Config.RangeInt(min=0, max=3)
            public int boneMealWorth = 1;
            @Config.Name(value="bonemeal_luck_percent_chance")
            @Config.Comment(value={"Percent chance that a bonemeal will get applied during a luck roll"})
            @Config.RangeInt(min=1, max=100)
            public int boneMealLuckPercentChance = 33;
            @Config.Name(value="bonemeal_luck_rolls")
            @Config.Comment(value={"Number of times that a rod may apply additional luck based bonemeal"})
            @Config.RangeInt(min=0, max=7)
            public int boneMealLuckRolls = 2;
            @Config.Name(value="aoe_radius")
            @Config.Comment(value={"Radius in which harvest rod breaks crops, bonemeals/plants/hoes blocks"})
            @Config.RangeInt(min=0, max=5)
            public int AOERadius = 2;
            @Config.Name(value="aoe_cooldown")
            @Config.Comment(value={"Ticks in between bonemealing/planting/hoeing blocks when player is using one of these AOE actions"})
            @Config.RangeInt(min=1, max=20)
            public int AOECooldown = 3;
            @Config.Name(value="max_capacity_per_plantable")
            @Config.Comment(value={"Maximum number of units harvest rod can hold per plantable item"})
            @Config.RangeInt(min=0, max=9999)
            public int maxCapacityPerPlantable = 250;
            @Config.Name(value="pedestal_range")
            @Config.Comment(value={"Range at which harvest rod will automatically hoe/plant/bonemeal/break crops around pedestal"})
            @Config.RangeInt(min=1, max=20)
            public int pedestalRange = 4;
            @Config.Name(value="pedestal_cooldown")
            @Config.Comment(value={"Ticks in between harvest rod actions when in pedestal"})
            @Config.RangeInt(min=1, max=20)
            public byte pedestalCooldown = (byte)5;
        }

        public class GlacialStaffSettings {
            @Config.Name(value="snowball_limit")
            @Config.Comment(value={"Number of snowballs the staff can hold"})
            @Config.RangeInt(min=0, max=9999)
            public int snowballLimit = 250;
            @Config.Name(value="snowball_cost")
            @Config.Comment(value={"Number of snowballs it costs when the staff is used"})
            @Config.RangeInt(min=0, max=3)
            public int snowballCost = 1;
            @Config.Name(value="snowball_worth")
            @Config.Comment(value={"Number of snowballs that get added to the staff per one that's consumed from player's inventory"})
            @Config.RangeInt(min=0, max=3)
            public int snowballWorth = 1;
            @Config.Name(value="snowball_damage")
            @Config.Comment(value={"The damage that snowballs cause"})
            @Config.RangeInt(min=0, max=6)
            public int snowballDamage = 3;
            @Config.Name(value="snowball_damage_bonus_fire_immune")
            @Config.Comment(value={"The damage bonus against entities that are immune to fire"})
            @Config.RangeInt(min=0, max=6)
            public int snowballDamageBonusFireImmune = 3;
            @Config.Name(value="snowball_damage_bonus_blaze")
            @Config.Comment(value={"The damage bonus against blaze"})
            @Config.RangeInt(min=0, max=12)
            public int snowballDamageBonusBlaze = 6;
        }

        public class FortuneCoinSettings {
            @Config.Name(value="disable_audio")
            @Config.Comment(value={"Disables the sound of fortune coin teleporting stuff"})
            public boolean disableAudio = false;
            @Config.Name(value="standard_pull_distance")
            @Config.Comment(value={"The distance that it pulls from when activated"})
            @Config.RangeInt(min=3, max=10)
            public int standardPullDistance = 5;
            @Config.Name(value="long_range_pull_distance")
            @Config.Comment(value={"The distance that it pulls from when right click is held"})
            @Config.RangeInt(min=9, max=30)
            public int longRangePullDistance = 15;
        }

        public class EnderStaffSettings {
            @Config.Name(value="ender_pearl_cast_cost")
            @Config.Comment(value={"Number of ender pearls per use"})
            @Config.RangeInt(min=0, max=3)
            public int enderPearlCastCost = 1;
            @Config.Name(value="ender_pearl_node_warp_cost")
            @Config.Comment(value={"Number of ender pearls per teleportation to the wraith node"})
            @Config.RangeInt(min=0, max=3)
            public int enderPearlNodeWarpCost = 1;
            @Config.Name(value="ender_pearl_worth")
            @Config.Comment(value={"Number of ender pearls that get added to the staff per one that's consumed from players inventory"})
            @Config.RangeInt(min=0, max=10)
            public int enderPearlWorth = 1;
            @Config.Name(value="ender_pearl_limit")
            @Config.Comment(value={"Number of ender pearls that the ender staff can store"})
            @Config.RangeInt(min=0, max=9999)
            public int enderPearlLimit = 250;
            @Config.Name(value="node_warp_cast_time")
            @Config.Comment(value={"Time it takes to teleport to the wraith node"})
            @Config.RangeInt(min=10, max=120)
            public int nodeWarpCastTime = 60;
        }

        public class EmperorChaliceSettings {
            @Config.Name(value="hunger_satiation_multiplier")
            @Config.Comment(value={"How much saturation is added in addition to filling the hunger"})
            @Config.RangeInt(min=0, max=10)
            public int hungerSatiationMultiplier = 4;
        }

        public class DestructionCatalystSettings {
            @Config.Name(value="mundane_blocks")
            @Config.Comment(value={"List of mundane blocks the catalyst will break"})
            public String[] mundaneBlocks = new String[]{"minecraft:dirt", "minecraft:grass", "minecraft:gravel", "minecraft:cobblestone", "minecraft:stone", "minecraft:sand", "minecraft:sandstone", "minecraft:snow", "minecraft:soul_sand", "minecraft:netherrack", "minecraft:end_stone"};
            @Config.Name(value="gunpowder_cost")
            @Config.Comment(value={"Number of gunpowder it costs per catalyst use"})
            @Config.RangeInt(min=0, max=10)
            public int gunpowderCost = 3;
            @Config.Name(value="gunpowder_worth")
            @Config.Comment(value={"Number of gunpowder that gets added to catalyst per one that's consumed from players inventory"})
            @Config.RangeInt(min=0, max=3)
            public int gunpowderWorth = 1;
            @Config.Name(value="gunpowder_limit")
            @Config.Comment(value={"Number of gunpowder that can be stored in destruction catalyst"})
            @Config.RangeInt(min=0, max=9999)
            public int gunpowderLimit = 250;
            @Config.Name(value="explosion_radius")
            @Config.Comment(value={"Radius of the explosion"})
            @Config.RangeInt(min=1, max=5)
            public int explosionRadius = 1;
            @Config.Name(value="centered_explosion")
            @Config.Comment(value={"Whether the explosion is centered on the block that gets clicked"})
            public boolean centeredExplosion = false;
            @Config.Name(value="perfect_cube")
            @Config.Comment(value={"Whether the explosion makes a perfect cube hole"})
            public boolean perfectCube = true;
        }

        public class AngelHeartVialSettings {
            @Config.Name(value="heal_percentage_of_max_life")
            @Config.Comment(value={"Percent of life that gets healed when the player would die"})
            @Config.RangeInt(min=0, max=100)
            public int healPercentageOfMaxLife = 25;
            @Config.Name(value="remove_negative_status")
            @Config.Comment(value={"Whether the player gets negative statuses removed"})
            public boolean removeNegativeStatus = true;
        }

        public class AngelicFeatherSettings {
            @Config.Name(value="hunger_cost_percent")
            @Config.Comment(value={"Percent hunger used to heal player per 1 damage that would be taken otherwise."})
            @Config.RangeInt(min=0, max=100)
            public int hungerCostPercent = 50;
            @Config.Name(value="leaping_potency")
            @Config.Comment(value={"Potency of the leaping effect"})
            @Config.RangeInt(min=0, max=5)
            public int leapingPotency = 1;
        }

        public class AlkahestryTomeSettings {
            @Config.Name(value="charge_limit")
            @Config.Comment(value={"Charge limit of the tome"})
            @Config.RangeInt(min=0, max=9999)
            public int chargeLimit = 1000;
        }
    }

    public static class HudPos {
        @Config.Name(value="sojourner_staff")
        @Config.Comment(value={"Position of Sojouner Staff HUD"})
        public HUDPosition sojournerStaff = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="handgun")
        @Config.Comment(value={"Position of Handgun HUD"})
        public HUDPosition handgun = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="alkahestry_tome")
        @Config.Comment(value={"Position of Alkahestry Tome HUD"})
        public HUDPosition alkahestryTome = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="destruction_catalyst")
        @Config.Comment(value={"Position of Destruction Catalyst HUD"})
        public HUDPosition destructionCatalyst = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="ender_staff")
        @Config.Comment(value={"Position of Ender Staff HUD"})
        public HUDPosition enderStaff = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="ice_magus_rod")
        @Config.Comment(value={"Position of Ice Magus Rod HUD"})
        public HUDPosition iceMagusRod = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="glacial_staff")
        @Config.Comment(value={"Position of Glacial Staff HUD"})
        public HUDPosition glacialStaff = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="void_tear")
        @Config.Comment(value={"Position of Void Tear HUD"})
        public HUDPosition voidTear = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="midas_touchstone")
        @Config.Comment(value={"Position of Midas Touchstone HUD"})
        public HUDPosition midasTouchstone = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="harvest_rod")
        @Config.Comment(value={"Position of Harvest Rod HUD"})
        public HUDPosition harvestRod = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="infernal_chalice")
        @Config.Comment(value={"Position of Infernal Chalice HUD"})
        public HUDPosition infernalChalice = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="hero_medallion")
        @Config.Comment(value={"Position of Hero Medallion HUD"})
        public HUDPosition heroMedallion = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="pyromancer_staff")
        @Config.Comment(value={"Position of Pyromancer Staff HUD"})
        public HUDPosition pyromancerStaff = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="rending_gale")
        @Config.Comment(value={"Position of Rending Gale HUD"})
        public HUDPosition rendingGale = HUDPosition.BOTTOM_RIGHT;
        @Config.Name(value="mob_charm")
        @Config.Comment(value={"Position of Mob Charm HUD"})
        public HUDPosition mobCharm = HUDPosition.RIGHT;
    }

    public static class PotionSettings {
        @Config.Name(value="potion_map")
        @Config.Comment(value={"Map of potion ingredients and their effects"})
        public String[] potionMap = PotionMap.getDefaultConfigPotionMap();
        @Config.Name(value="max_effect_count")
        @Config.Comment(value={"Maximum number of effects a potion can have to appear in creative tabs / JEI"})
        @Config.RangeInt(min=1, max=6)
        public int maxEffectCount = 1;
        @Config.Name(value="three_ingredients")
        @Config.Comment(value={"Whether potions that are made out of three base ingredients appear in creative tabs / JEI"})
        public boolean threeIngredients = false;
        @Config.Name(value="different_durations")
        @Config.Comment(value={"Whether potions augmented with Redstone and Glowstone appear in creative tabs / JEI"})
        public boolean differentDurations = false;
        @Config.Name(value="redstone_and_glowstone")
        @Config.Comment(value={"Whether potions with the same effect combination, but different duration appear in creative tabs / JEI"})
        public boolean redstoneAndGlowstone = false;
    }

    public static class DisableSettings {
        @Config.Name(value="alkahestry_tome")
        @Config.Comment(value={"Disable Alkahestry tome and its and recipes"})
        @Config.RequiresMcRestart
        public boolean disableAlkahestry = false;
        @Config.Name(value="handgun")
        @Config.Comment(value={"Disable the handgun, bullets, magazines, and gun parts"})
        @Config.RequiresMcRestart
        public boolean disableHandgun = false;
        @Config.Name(value="potion")
        @Config.Comment(value={"Disable the potion system including mortar, altar, potions, tipped arrows, and powder"})
        @Config.RequiresMcRestart
        public boolean disablePotions = false;
        @Config.Name(value="pedestal")
        @Config.Comment(value={"Disable all pedestals"})
        @Config.RequiresMcRestart
        public boolean disablePedestal = false;
        @Config.Name(value="pedestal_passive")
        @Config.Comment(value={"Disable all display-only pedestals"})
        @Config.RequiresMcRestart
        public boolean disablePedestalPassive = false;
    }

    @Mod.EventBusSubscriber(modid="xreliquary")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("xreliquary")) {
                ConfigManager.sync((String)"xreliquary", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

