/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.crafting;

import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import rustic.common.Config;
import rustic.common.blocks.fluids.FluidBooze;

public class BrewingBarrelRecipe {
    private static final Random rand = new Random();
    protected final FluidStack input;
    protected final FluidStack output;

    public BrewingBarrelRecipe(FluidStack output, FluidStack input) {
        this.output = output;
        this.input = input;
    }

    public boolean matches(FluidStack in) {
        if (this.input != null && this.input.getFluid() != null && in != null && in.getFluid() != null) {
            return in.getFluid().getName().equals(this.input.getFluid().getName());
        }
        return false;
    }

    public boolean matches(FluidStack in, FluidStack aux) {
        if (this.output != null && this.output.getFluid() != null && aux != null && aux.getFluid() != null) {
            return this.matches(in) && aux.getFluid() == this.output.getFluid();
        }
        if (aux == null) {
            return this.matches(in);
        }
        return false;
    }

    public FluidStack getResult(FluidStack in) {
        if (this.matches(in) && this.output != null && this.output.getFluid() != null) {
            FluidStack out = this.output.copy();
            if (this.output.getFluid() instanceof FluidBooze) {
                if (out.tag == null) {
                    out.tag = new NBTTagCompound();
                }
                out.tag.func_74776_a("Quality", (float)(5 + rand.nextInt(71)) / 100.0f);
            }
            return out;
        }
        return null;
    }

    public FluidStack getResult(FluidStack in, FluidStack aux) {
        if (aux == null || aux.getFluid() == null || !this.matches(in, aux) || !(aux.getFluid() instanceof FluidBooze)) {
            return this.getResult(in);
        }
        if (this.matches(in, aux) && this.output != null && this.output.getFluid() != null) {
            FluidStack out = this.output.copy();
            if (this.output.getFluid() instanceof FluidBooze && aux.tag != null && aux.tag.func_74764_b("Quality")) {
                float auxQuality = aux.tag.func_74760_g("Quality");
                if (Config.MAX_BREW_QUALITY_CHANGE < Config.MIN_BREW_QUALITY_CHANGE) {
                    Config.MAX_BREW_QUALITY_CHANGE = Config.MIN_BREW_QUALITY_CHANGE;
                }
                int brewQualityChange = rand.nextInt(Config.MAX_BREW_QUALITY_CHANGE - Config.MIN_BREW_QUALITY_CHANGE + 1) + Config.MIN_BREW_QUALITY_CHANGE;
                float quality = Math.max(Math.min((float)(brewQualityChange + (int)(100.0f * auxQuality)) / 100.0f, 1.0f), 0.0f);
                if (out.tag == null) {
                    out.tag = new NBTTagCompound();
                }
                out.tag.func_74776_a("Quality", quality);
            }
            return out;
        }
        return null;
    }

    public FluidStack getInput() {
        return this.input.copy();
    }
}

