/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.json.deserializer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.teamacronymcoders.base.blocks.BlockStateMatcher;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockStateMatcherDeserializer
implements JsonDeserializer<BlockStateMatcher> {
    public BlockStateMatcher deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject;
        String blockName;
        Block block;
        if (json != null && json.isJsonObject() && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName = JsonUtils.func_151200_h((JsonObject)(jsonObject = json.getAsJsonObject()), (String)"block")))) != null) {
            if (jsonObject.has("properties")) {
                BlockStateContainer blockStateContainer = block.func_176194_O();
                JsonObject properties = jsonObject.getAsJsonObject("properties");
                HashMap propertyMatching = Maps.newHashMap();
                for (Map.Entry entry : properties.entrySet()) {
                    IProperty property = blockStateContainer.func_185920_a((String)entry.getKey());
                    if (property != null) {
                        ArrayList acceptableValues = Lists.newArrayList();
                        ArrayList acceptableStringValues = Lists.newArrayList();
                        JsonElement jsonValues = (JsonElement)entry.getValue();
                        if (jsonValues.isJsonArray()) {
                            jsonValues.getAsJsonArray().iterator().forEachRemaining(value -> acceptableStringValues.add(value.getAsString()));
                        } else {
                            acceptableStringValues.add(jsonValues.getAsString());
                        }
                        for (String value2 : acceptableStringValues) {
                            property.func_185929_b(value2).toJavaUtil().ifPresent(acceptableValues::add);
                        }
                        propertyMatching.put(property, acceptableValues);
                        continue;
                    }
                    throw new JsonParseException("Failed to find property: " + (String)entry.getKey());
                }
                return new BlockStateMatcher(block, propertyMatching);
            }
            return new BlockStateMatcher(block);
        }
        if (json == null) {
            throw new JsonParseException("Found null value for BlockState Input");
        }
        throw new JsonParseException("Failed to deserialize BlockState for: " + json.toString());
    }
}

