/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.blocks;

import com.google.common.collect.Maps;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.event.PlaceWaypointEvent;
import com.teamacronymcoders.base.items.IDropTable;
import com.teamacronymcoders.base.items.ItemStackDropTable;
import com.teamacronymcoders.base.materialsystem.MaterialSystem;
import com.teamacronymcoders.base.materialsystem.MaterialUser;
import com.teamacronymcoders.base.materialsystem.blocks.SubBlockPart;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.materialsystem.partdata.DataPartParsers;
import com.teamacronymcoders.base.materialsystem.partdata.MaterialPartData;
import com.teamacronymcoders.base.materialsystem.parts.Part;
import com.teamacronymcoders.base.util.DropUtils;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SubBlockOreSamplePart
extends SubBlockPart {
    private String itemDrop;
    private boolean requireTool;
    private String activatedText;
    private IDropTable dropTable = null;

    public SubBlockOreSamplePart(MaterialPart materialPart, MaterialUser materialUser) {
        super(materialPart, MaterialSystem.materialCreativeTab);
        MaterialPartData data = materialPart.getData();
        this.setHardness(data.getValue("hardness", Float.valueOf(0.125f), DataPartParsers::getFloat).floatValue());
        this.setResistance(data.getValue("resistance", 2, DataPartParsers::getInt));
        this.setHarvestLevel(data.getValue("harvestLevel", -1, DataPartParsers::getInt));
        this.setHarvestTool(data.getValue("harvestTool", null, DataPartParsers::getString));
        this.itemDrop = data.getValue("drops", this.itemDrop, DataPartParsers::getString);
        this.requireTool = data.getValue("requireTool", this.requireTool, DataPartParsers::getBool);
        this.activatedText = data.getValue("activatedText", this.activatedText, DataPartParsers::getString);
    }

    @Override
    public Material getMaterial() {
        if (this.requireTool) {
            return Material.field_151576_e;
        }
        return Material.field_151578_c;
    }

    @Override
    public void getDrops(int fortune, List<ItemStack> itemStacks) {
        if (this.dropTable == null) {
            this.dropTable = this.itemDrop != null && !this.itemDrop.isEmpty() ? DropUtils.parseDrops(this.itemDrop) : new ItemStackDropTable(this.getItemStack());
        }
        itemStacks.addAll(this.dropTable.getDrops(fortune));
    }

    @Override
    public IGeneratedModel getGeneratedModel() {
        TemplateFile templateFile = TemplateManager.getTemplateFile("ore_sample_block");
        HashMap replacements = Maps.newHashMap();
        Part part = this.getMaterialPart().getPart();
        replacements.put("texture", String.format("%s:blocks/%s", "minecraft", "gravel"));
        replacements.put("particle", String.format("%s:blocks/%s", "minecraft", "stone"));
        replacements.put("ore", String.format("%s:blocks/%s", part.getOwnerId(), part.getShortUnlocalizedName()));
        templateFile.replaceContents(replacements);
        return new GeneratedModel(this.getModelPrefix() + this.getUnLocalizedName(), ModelType.BLOCKSTATE, templateFile.getFileContents());
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean isTopSolid() {
        return false;
    }

    @Override
    public BlockFaceShape getBlockFaceShape() {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 0.25, (double)0.8f);
    }

    @Override
    public boolean isFullCube() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean isPassable() {
        return true;
    }

    @Override
    public boolean isFullBlock() {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public boolean canSilkHarvest() {
        return false;
    }

    @Override
    public void onNeighborChange(World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
            if (!this.requireTool) {
                this.getBlock().func_176226_b(world, pos, this.getBlockState(), 0);
            }
            world.func_175698_g(pos);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, @Nonnull BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP);
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, EntityPlayer player) {
        if (this.activatedText != null && !this.activatedText.isEmpty()) {
            player.func_146105_b((ITextComponent)new TextComponentString(this.activatedText), true);
            world.func_175698_g(pos);
        } else if (!this.requireTool) {
            this.getBlock().func_176226_b(world, pos, this.getBlockState(), 0);
            world.func_175698_g(pos);
        }
        if (player.func_70093_af()) {
            MinecraftForge.EVENT_BUS.post((Event)new PlaceWaypointEvent(this.getLocalizedName(), world.field_73011_w.getDimension(), pos, this.getColor()));
        }
        player.func_184609_a(EnumHand.MAIN_HAND);
        return true;
    }
}

