/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.nbt.converters;

import com.teamacronymcoders.base.nbt.INBTConverter;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class NBTFluidTankConverter
implements INBTConverter<FluidTank> {
    private String name;

    public NBTFluidTankConverter setKey(String key) {
        this.name = key;
        return this;
    }

    @Override
    public FluidTank convert(NBTTagCompound tag) {
        String fluidName;
        NBTTagCompound tank = tag.func_74775_l(this.name);
        FluidStack fluid = null;
        fluid = !tank.func_74764_b("Empty") ? ((fluidName = tank.func_74779_i("FluidName")) == null || FluidRegistry.getFluid((String)fluidName) == null ? null : new FluidStack(FluidRegistry.getFluid((String)fluidName), tank.func_74762_e("Amount"))) : null;
        if (fluid != null) {
            return new FluidTank(fluid, tank.func_74762_e("capacity"));
        }
        return new FluidTank(tank.func_74762_e("capacity"));
    }

    @Override
    public NBTTagCompound convert(NBTTagCompound tag, FluidTank value) {
        NBTTagCompound tank = new NBTTagCompound();
        tank.func_74768_a("capacity", value.getCapacity());
        if (value.getFluid() != null) {
            tank.func_74778_a("FluidName", FluidRegistry.getFluidName((FluidStack)value.getFluid()));
            tank.func_74768_a("Amount", value.getFluidAmount());
        } else {
            tank.func_74778_a("Empty", "");
        }
        tag.func_74782_a(this.name, (NBTBase)tank);
        return tag;
    }
}

