/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorLakes;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorSplotches;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeGenVolcanicIsland
extends BOPOverworldBiome {
    public BiomeGenVolcanicIsland() {
        super("volcanic_island", new BOPBiome.PropsBuilder("Volcanic Island").withGuiColour(0x656565).withTemperature(Float.valueOf(1.2f)).withRainfall(Float.valueOf(0.2f)));
        this.terrainSettings.avgHeight(120.0).heightVariation(50.0, 50.0).octaves(1.0, 1.0, 2.0, 2.0, 3.0, 2.0).sidewaysNoise(0.1);
        this.field_76752_A = BOPBlocks.ash_block.func_176223_P();
        this.field_76753_B = BOPBlocks.ash_block.func_176223_P();
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.canGenerateRivers = false;
        this.field_76760_I.field_76808_K = false;
        this.beachBiomeLocation = null;
        this.avgDirtDepth = 16;
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.clearWeights();
        IBlockPosQuery emptyAshBlock = BlockQuery.buildAnd().withAirAbove().states(this.field_76752_A).create();
        this.addGenerator("lava_flows", GeneratorStage.FLOWERS, ((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)new GeneratorSplotches.Builder().placeOn(emptyAshBlock)).replace(BOPBlocks.ash_block)).amountPerChunk(0.1f)).splotchSize(12).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_SURFACE)).with(Blocks.field_150356_k.func_176223_P())).create());
        this.addGenerator("lava_lakes", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(2.5f)).lavaLake().create());
        this.addGenerator("ruby", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.RUBY)).create());
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL) && rand.nextInt(64) == 0) {
            new WorldGenFossils().func_180709_b(worldIn, rand, pos);
        }
    }
}

