/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.command.team;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CmdInfo
extends CmdBase {
    public CmdInfo() {
        super("info", CmdBase.Level.ALL);
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return CmdInfo.func_175762_a((String[])args, Universe.get().getTeams());
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        this.checkArgs(sender, args, 1);
        ForgeTeam team = Universe.get().getTeam(args[0]);
        if (!team.isValid()) {
            throw FTBLib.error(sender, "ftblib.lang.team.error.not_found", args[0]);
        }
        sender.func_145747_a(FTBLib.lang(sender, "commands.team.info.id", StringUtils.color((ITextComponent)new TextComponentString(team.getID()), TextFormatting.BLUE)));
        sender.func_145747_a(FTBLib.lang(sender, "commands.team.info.uid", StringUtils.color((ITextComponent)new TextComponentString(team.getUID() + " / " + String.format("%04x", team.getUID())), TextFormatting.BLUE)));
        sender.func_145747_a(FTBLib.lang(sender, "commands.team.info.owner", team.owner == null ? "-" : StringUtils.color(team.owner.getDisplayName(), TextFormatting.BLUE)));
        TextComponentString component = new TextComponentString("");
        component.func_150256_b().func_150238_a(TextFormatting.GOLD);
        boolean first = true;
        for (ForgePlayer player : team.getMembers()) {
            if (first) {
                first = false;
            } else {
                component.func_150258_a(", ");
            }
            ITextComponent n = player.getDisplayName();
            n.func_150256_b().func_150238_a(TextFormatting.BLUE);
            component.func_150257_a(n);
        }
        sender.func_145747_a(FTBLib.lang(sender, "commands.team.info.members", component));
    }
}

