/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CombinedIcon
extends Icon {
    public final List<Icon> list;

    public static Icon getCombined(Collection<Icon> icons) {
        ArrayList<Icon> list = new ArrayList<Icon>(icons.size());
        for (Icon icon : icons) {
            if (icon.isEmpty()) continue;
            list.add(icon);
        }
        if (list.isEmpty()) {
            return EMPTY;
        }
        if (list.size() == 1) {
            return (Icon)list.get(0);
        }
        return new CombinedIcon(list);
    }

    CombinedIcon(Collection<Icon> icons) {
        this.list = new ArrayList<Icon>(icons.size());
        for (Icon icon : icons) {
            if (icon.isEmpty()) continue;
            this.list.add(icon);
        }
    }

    CombinedIcon(Icon o1, Icon o2) {
        this.list = new ArrayList<Icon>(2);
        this.list.add(o1);
        this.list.add(o2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h, Color4I col) {
        for (Icon icon : this.list) {
            icon.draw(x, y, w, h, col);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawStatic(int x, int y, int w, int h) {
        for (Icon icon : this.list) {
            icon.drawStatic(x, y, w, h);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw3D(Color4I col) {
        for (Icon icon : this.list) {
            icon.draw3D(col);
        }
    }

    @Override
    public JsonElement getJson() {
        JsonArray json = new JsonArray();
        for (Icon o : this.list) {
            json.add(o.getJson());
        }
        return json;
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof CombinedIcon && this.list.equals(((CombinedIcon)o).list);
    }
}

