/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network;

import java.util.HashMap;
import mod.chiselsandbits.network.ModPacket;
import mod.chiselsandbits.network.packets.PacketAccurateSneakPlace;
import mod.chiselsandbits.network.packets.PacketBagGui;
import mod.chiselsandbits.network.packets.PacketBagGuiStack;
import mod.chiselsandbits.network.packets.PacketChisel;
import mod.chiselsandbits.network.packets.PacketClearBagGui;
import mod.chiselsandbits.network.packets.PacketOpenBagGui;
import mod.chiselsandbits.network.packets.PacketRotateVoxelBlob;
import mod.chiselsandbits.network.packets.PacketSetChiselMode;
import mod.chiselsandbits.network.packets.PacketSetColor;
import mod.chiselsandbits.network.packets.PacketSortBagGui;
import mod.chiselsandbits.network.packets.PacketSuppressInteraction;
import mod.chiselsandbits.network.packets.PacketUndo;

public enum ModPacketTypes {
    CHISEL(PacketChisel.class),
    OPEN_BAG_GUI(PacketOpenBagGui.class),
    SET_CHISEL_MODE(PacketSetChiselMode.class),
    ROTATE_VOXEL_BLOB(PacketRotateVoxelBlob.class),
    BAG_GUI(PacketBagGui.class),
    BAG_GUI_STACK(PacketBagGuiStack.class),
    UNDO(PacketUndo.class),
    CLEAR_BAG(PacketClearBagGui.class),
    SUPRESS_INTERACTION(PacketSuppressInteraction.class),
    SET_COLOR(PacketSetColor.class),
    ACCURATE_PLACEMENT(PacketAccurateSneakPlace.class),
    SORT_BAG_GUI(PacketSortBagGui.class);

    private final Class<? extends ModPacket> packetClass;
    private static HashMap<Class<? extends ModPacket>, Integer> fromClassToId;
    private static HashMap<Integer, Class<? extends ModPacket>> fromIdToClass;

    private ModPacketTypes(Class<? extends ModPacket> clz) {
        this.packetClass = clz;
    }

    public static void init() {
        for (ModPacketTypes p : ModPacketTypes.values()) {
            fromClassToId.put(p.packetClass, p.ordinal());
            fromIdToClass.put(p.ordinal(), p.packetClass);
        }
    }

    public static int getID(Class<? extends ModPacket> clz) {
        return fromClassToId.get(clz);
    }

    public static ModPacket constructByID(int id) throws InstantiationException, IllegalAccessException {
        return fromIdToClass.get(id).newInstance();
    }

    static {
        fromClassToId = new HashMap();
        fromIdToClass = new HashMap();
    }
}

