/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.render.tile;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.models.obj.OBJModelLibrary;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.item.IItemRenderer;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.base.patreon.base.PtEffectCorruptedCelestialCrystal;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.item.block.ItemCollectorCrystal;
import hellfirepvp.astralsorcery.common.tile.network.TileCollectorCrystal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.awt.Color;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;

public class TESRCollectorCrystal
extends TileEntitySpecialRenderer<TileCollectorCrystal>
implements IItemRenderer {
    private static final BindableResource texWhite = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MODELS, "crystal_big_white");
    private static final BindableResource texBlue = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MODELS, "crystal_big_blue");
    private static final BindableResource texRed = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MODELS, "crystal_big_red");
    private static int dlCrystal = -1;

    public void render(TileCollectorCrystal te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        UUID playerUUID = te.getPlayerReference();
        BlockCollectorCrystalBase.CollectorCrystalType type = te.getType();
        if (te.doesSeeSky()) {
            Color c;
            long sBase = 1553015L;
            sBase ^= (long)te.func_174877_v().func_177958_n();
            sBase ^= (long)te.func_174877_v().func_177956_o();
            sBase ^= (long)te.func_174877_v().func_177952_p();
            Color color = c = type == null ? BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL.displayColor : type.displayColor;
            if (te.getType() == BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL && playerUUID != null && MiscUtils.contains(PatreonEffectHelper.getPatreonEffects(Side.CLIENT, playerUUID), pe -> pe instanceof PtEffectCorruptedCelestialCrystal)) {
                c = Color.RED;
            }
            if (te.isEnhanced()) {
                c = te.getConstellation() != null ? te.getConstellation().getConstellationColor() : c;
                RenderingUtils.renderLightRayEffects(x + 0.5, y + 0.5, z + 0.5, c, sBase, ClientScheduler.getClientTick(), 20, 1.4f, 50, 25);
                RenderingUtils.renderLightRayEffects(x + 0.5, y + 0.5, z + 0.5, Color.WHITE, sBase, ClientScheduler.getClientTick(), 40, 2.0f, 15, 15);
            } else {
                RenderingUtils.renderLightRayEffects(x + 0.5, y + 0.5, z + 0.5, c, sBase, ClientScheduler.getClientTick(), 20, 50, 25);
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
        TESRCollectorCrystal.renderCrystal(playerUUID, type == BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL, true);
        GlStateManager.func_179121_F();
    }

    public static void renderCrystal(@Nullable UUID playerUUID, boolean isCelestial, boolean bounce) {
        GlStateManager.func_179094_E();
        if (bounce) {
            int t = (int)(Minecraft.func_71410_x().field_71441_e.func_82737_E() & 0xFFL);
            float perc = (float)(256 - t) / 256.0f;
            perc = MathHelper.func_76134_b((float)((float)((double)(perc * 2.0f) * Math.PI)));
            GlStateManager.func_179137_b((double)0.0, (double)(0.03 * (double)perc), (double)0.0);
        }
        TextureHelper.refreshTextureBindState();
        RenderHelper.func_74518_a();
        if (isCelestial) {
            if (playerUUID != null && MiscUtils.contains(PatreonEffectHelper.getPatreonEffects(Side.CLIENT, playerUUID), pe -> pe instanceof PtEffectCorruptedCelestialCrystal)) {
                TESRCollectorCrystal.renderTile(texRed);
            } else {
                TESRCollectorCrystal.renderTile(texBlue);
            }
        } else {
            TESRCollectorCrystal.renderTile(texWhite);
        }
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private static void renderTile(BindableResource tex) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.13f, (float)0.13f, (float)0.13f);
        tex.bind();
        if (dlCrystal == -1) {
            dlCrystal = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)dlCrystal, (int)4864);
            OBJModelLibrary.bigCrystal.renderAll(true);
            GlStateManager.func_187415_K();
        }
        GlStateManager.func_179148_o((int)dlCrystal);
        GlStateManager.func_179121_F();
    }

    @Override
    public void render(ItemStack stack) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
        RenderHelper.func_74518_a();
        BlockCollectorCrystalBase.CollectorCrystalType type = ItemCollectorCrystal.getType(stack);
        switch (type) {
            case ROCK_CRYSTAL: {
                TESRCollectorCrystal.renderTile(texWhite);
                break;
            }
            case CELESTIAL_CRYSTAL: {
                TESRCollectorCrystal.renderTile(texBlue);
                break;
            }
        }
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }
}

