/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.cape.impl;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeArmorEffect;
import hellfirepvp.astralsorcery.common.entities.EntityFlare;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class CapeEffectBootes
extends CapeArmorEffect {
    private static int maxFlareCount = 3;
    private static float summonFlareChance = 0.005f;

    public CapeEffectBootes(NBTTagCompound cmp) {
        super(cmp, "bootes");
    }

    public void onPlayerTick(EntityPlayer pl) {
        World w = pl.func_130014_f_();
        int current = this.gatherEntities(w).size();
        EntityFlare flare = null;
        if (current < maxFlareCount && rand.nextFloat() < summonFlareChance) {
            Vector3 pos = Vector3.atEntityCenter((Entity)pl);
            flare = new EntityFlare(w, pos.getX(), pos.getY(), pos.getZ());
            flare.setFollowingTarget(pl);
            w.func_72838_d((Entity)flare);
        }
        this.updateEntityList(w, (Entity)flare);
        List<Entity> fl = this.gatherEntities(w);
        for (Entity e : fl) {
            if (!(e instanceof EntityFlare) || ((EntityFlare)e).getFollowingEntity() == null || !(pl.func_70032_d(e) >= 10.0f)) continue;
            e.func_70080_a(pl.field_70165_t, pl.field_70163_u, pl.field_70161_v, 0.0f, 0.0f);
        }
    }

    public void onPlayerDamagedByEntity(EntityPlayer player, EntityLivingBase attacker) {
        List<Entity> entityFlares = this.gatherEntities(player.func_130014_f_());
        for (Entity e : entityFlares) {
            if (!(e instanceof EntityFlare)) continue;
            ((EntityFlare)e).func_70624_b(attacker);
        }
    }

    private List<Integer> updateEntityList(World currentWorld, @Nullable Entity newEntityAdded) {
        List<Integer> current = this.gatherEntityIds();
        LinkedList<Integer> out = new LinkedList<Integer>();
        for (Integer id : current) {
            Entity e = currentWorld.func_73045_a(id.intValue());
            if (e == null || e.field_70128_L || !(e instanceof EntityFlare)) continue;
            out.add(id);
        }
        if (newEntityAdded != null && !newEntityAdded.field_70128_L) {
            out.add(newEntityAdded.func_145782_y());
        }
        this.pushEntityIds(out);
        return out;
    }

    private void pushEntityIds(List<Integer> out) {
        NBTTagList list = new NBTTagList();
        for (Integer id : out) {
            list.func_74742_a((NBTBase)new NBTTagInt(id.intValue()));
        }
        this.getData().func_74782_a("AS_Bootes_Entities", (NBTBase)list);
    }

    private List<Entity> gatherEntities(World currentWorld) {
        List<Integer> current = this.gatherEntityIds();
        LinkedList<Entity> out = new LinkedList<Entity>();
        for (Integer id : current) {
            Entity e = currentWorld.func_73045_a(id.intValue());
            if (e == null || e.field_70128_L || !(e instanceof EntityFlare)) continue;
            out.add(e);
        }
        return out;
    }

    private List<Integer> gatherEntityIds() {
        LinkedList<Integer> entities = new LinkedList<Integer>();
        NBTTagList list = this.getData().func_150295_c("AS_Bootes_Entities", 3);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            entities.add(list.func_186858_c(i));
        }
        return entities;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        maxFlareCount = cfg.getInt(this.getKey() + "MaxFlareCount", this.getConfigurationSection(), maxFlareCount, 2, 8, "Defines the maximum flare count the player can draw with him.");
        summonFlareChance = cfg.getFloat(this.getKey() + "TickSummonChance", this.getConfigurationSection(), summonFlareChance, 0.0f, 1.0f, "Defines the chance per tick that a new flare following the wearer is spawned.");
    }

    @Override
    public IConstellation getAssociatedConstellation() {
        return Constellations.bootes;
    }

    @Override
    public void playActiveParticleTick(EntityPlayer pl) {
        this.playConstellationCapeSparkles(pl, 0.2f);
    }
}

