/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.base.OreTypes;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.CEffectPositionList;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.GenListEntries;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.ILocatable;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CEffectMineralis
extends CEffectPositionList {
    public static boolean enabled = true;
    public static double potencyMultiplier = 1.0;
    public static int searchRange = 8;
    public static int maxCount = 2;

    public CEffectMineralis(@Nullable ILocatable origin) {
        super(origin, Constellations.mineralis, "mineralis", maxCount, (world, pos) -> {
            IBlockState state = world.func_180495_p(pos);
            return state.func_177230_c() == Blocks.field_150348_b && ((BlockStone.EnumType)state.func_177229_b((IProperty)BlockStone.field_176247_a)).equals((Object)BlockStone.EnumType.STONE);
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float percEffectVisibility, boolean extendedEffects) {
        if (rand.nextBoolean()) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((double)((float)pos.func_177958_n() + rand.nextFloat() * 5.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5, (double)((float)pos.func_177956_o() + rand.nextFloat() * 2.0f) + 0.5, (double)((float)pos.func_177952_p() + rand.nextFloat() * 5.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5);
            p.motion(0.0, 0.0, 0.0).gravity(-0.01);
            p.scale(0.45f).setColor(new Color(188, 188, 188)).setMaxAge(55);
        }
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, float percStrength, ConstellationEffectProperties modified, @Nullable IMinorConstellation possibleTraitEffect) {
        BlockPos sel;
        GenListEntries.SimpleBlockPosEntry entry;
        if (!enabled) {
            return false;
        }
        if ((percStrength = (float)((double)percStrength * potencyMultiplier)) < 1.0f && world.field_73012_v.nextFloat() > percStrength) {
            return false;
        }
        boolean changed = false;
        if (modified.isCorrupted()) {
            List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(pos).func_186662_g(modified.getSize()));
            for (EntityLivingBase entity : entities) {
                if (entity instanceof EntityFlying || entity.field_70128_L) continue;
                BlockPos center = entity.func_180425_c().func_177977_b();
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        BlockPos at = center.func_177982_a(xx, 0, zz);
                        IBlockState state = world.func_180495_p(at);
                        if (!world.func_175623_d(at) && !state.func_177230_c().func_176200_f((IBlockAccess)world, at)) continue;
                        if (rand.nextInt(25) == 0) {
                            ItemStack blockStack = OreTypes.RITUAL_MINERALIS.getRandomOre(rand);
                            if (!blockStack.func_190926_b()) {
                                state = ItemUtils.createBlockState(blockStack);
                                if (state != null) {
                                    if (!world.func_175656_a(at, state)) continue;
                                    changed = true;
                                    continue;
                                }
                                if (!world.func_175656_a(at, Blocks.field_150348_b.func_176223_P())) continue;
                                changed = true;
                                continue;
                            }
                            if (!world.func_175656_a(at, Blocks.field_150348_b.func_176223_P())) continue;
                            changed = true;
                            continue;
                        }
                        if (!world.func_175656_a(at, Blocks.field_150348_b.func_176223_P())) continue;
                        changed = true;
                    }
                }
            }
        }
        if ((entry = (GenListEntries.SimpleBlockPosEntry)this.getRandomElementByChance(rand)) != null && MiscUtils.isChunkLoaded(world, new ChunkPos(sel = entry.getPos()))) {
            if (this.verifier.isValid(world, sel)) {
                IBlockState state;
                ItemStack blockStack = OreTypes.RITUAL_MINERALIS.getRandomOre(rand);
                if (rand.nextInt(2000000) == 0) {
                    blockStack = new ItemStack((Block)BlocksAS.customOre, 1, BlockCustomOre.OreType.STARMETAL.ordinal());
                }
                if (!blockStack.func_190926_b() && (state = ItemUtils.createBlockState(blockStack)) != null) {
                    world.func_175656_a(sel, state);
                }
            } else {
                this.removeElement(entry);
                changed = true;
            }
        }
        if (this.findNewPosition(world, pos, modified)) {
            changed = true;
        }
        return changed;
    }

    @Override
    public ConstellationEffectProperties provideProperties(int mirrorCount) {
        return new ConstellationEffectProperties(searchRange);
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        searchRange = cfg.getInt(this.getKey() + "Range", this.getConfigurationSection(), searchRange, 1, 32, "Defines the radius (in blocks) in which the ritual will search for cleanStone to generate ores into.");
        maxCount = cfg.getInt(this.getKey() + "Count", this.getConfigurationSection(), maxCount, 1, 4000, "Defines the amount of block-positions the ritual can cache at max count");
        enabled = cfg.getBoolean(this.getKey() + "Enabled", this.getConfigurationSection(), true, "Set to false to disable this ConstellationEffect.");
        potencyMultiplier = cfg.getFloat(this.getKey() + "PotencyMultiplier", this.getConfigurationSection(), 1.0f, 0.01f, 100.0f, "Set the potency multiplier for this ritual effect. Will affect all ritual effects and their efficiency.");
    }
}

