/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.world.data;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.auxiliary.CelestialGatewaySystem;
import hellfirepvp.astralsorcery.common.data.world.CachedWorldData;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.tile.TileCelestialGateway;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GatewayCache
extends CachedWorldData {
    private List<GatewayNode> gatewayPositions = new LinkedList<GatewayNode>();

    public GatewayCache() {
        super(WorldCacheManager.SaveKey.GATEWAY_DATA);
    }

    public List<GatewayNode> getGatewayPositions() {
        return new ArrayList<GatewayNode>(this.gatewayPositions);
    }

    public void offerPosition(World world, BlockPos pos, @Nonnull String display) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileCelestialGateway)) {
            return;
        }
        GatewayNode node = new GatewayNode(pos, display);
        if (this.gatewayPositions.contains((Object)node)) {
            return;
        }
        this.gatewayPositions.add(node);
        this.markDirty();
        CelestialGatewaySystem.instance.addPosition(world, node);
        AstralSorcery.log.info("Added new gateway node at: dim=" + world.field_73011_w.getDimension() + ", " + pos.toString());
    }

    public void removePosition(World world, BlockPos pos) {
        if (this.gatewayPositions.remove(pos)) {
            this.markDirty();
            CelestialGatewaySystem.instance.removePosition(world, pos);
            AstralSorcery.log.info("Removed gateway node at: dim=" + world.field_73011_w.getDimension() + ", " + pos.toString());
        }
    }

    @Override
    public void onLoad(World world) {
        AstralSorcery.log.info("Checking GatewayCache integrity for dimension " + world.field_73011_w.getDimension());
        long msStart = System.currentTimeMillis();
        Iterator<GatewayNode> iterator = this.gatewayPositions.iterator();
        while (iterator.hasNext()) {
            TileCelestialGateway gateway;
            GatewayNode node = iterator.next();
            try {
                gateway = MiscUtils.getTileAt((IBlockAccess)world, node, TileCelestialGateway.class, true);
            }
            catch (Exception loadEx) {
                AstralSorcery.log.info("Failed to check gateway for " + (Object)((Object)node) + " skipping");
                continue;
            }
            if (gateway != null) continue;
            iterator.remove();
            AstralSorcery.log.info("Invalid entry: " + (Object)((Object)node) + " - no gateway tileentity found there!");
        }
        AstralSorcery.log.info("GatewayCache checked and fully loaded in " + (System.currentTimeMillis() - msStart) + "ms! Collected and checked " + this.gatewayPositions.size() + " gateway nodes!");
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c("posList", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            BlockPos pos = NBTHelper.readBlockPosFromNBT(tag);
            String display = tag.func_74779_i("display");
            GatewayNode node = new GatewayNode(pos, display);
            this.gatewayPositions.add(node);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (GatewayNode node : this.gatewayPositions) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(node, tag);
            tag.func_74778_a("display", node.display);
            list.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("posList", (NBTBase)list);
    }

    @Override
    public void updateTick(World world) {
    }

    public static class GatewayNode
    extends BlockPos {
        public final String display;

        public GatewayNode(BlockPos pos, String display) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.display = display;
        }

        public boolean equals(Object pos) {
            return super.equals(pos);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

