/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.common.entities.EntityObservatoryHelper;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileObservatory
extends TileEntityTick {
    private UUID entityHelperRef;
    private Integer entityIdServerRef = null;
    public float observatoryYaw = 0.0f;
    public float prevObservatoryYaw = 0.0f;
    public float observatoryPitch = -45.0f;
    public float prevObservatoryPitch = -45.0f;

    @Override
    protected void onFirstTick() {
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.entityHelperRef == null) {
                this.createNewObservatoryEntity();
            } else {
                Entity e = this.resolveEntity(this.entityHelperRef);
                if (e == null || e.field_70128_L) {
                    this.createNewObservatoryEntity();
                } else {
                    double xOffset = -0.85;
                    double zOffset = 0.15;
                    double yawRad = -Math.toRadians(this.observatoryYaw);
                    double xComp = 0.5 + Math.sin(yawRad) * xOffset - Math.cos(yawRad) * zOffset;
                    double zComp = 0.5 + Math.cos(yawRad) * xOffset + Math.sin(yawRad) * zOffset;
                    Vector3 pos = new Vector3(this.func_174877_v()).add(xComp, 0.4f, zComp);
                    e.func_70634_a(pos.getX(), pos.getY(), pos.getZ());
                }
            }
        }
    }

    public boolean isUsable() {
        for (int xx = -1; xx <= 1; ++xx) {
            for (int zz = -1; zz <= 1; ++zz) {
                if (xx == 0 && zz == 0) continue;
                BlockPos other = this.field_174879_c.func_177982_a(xx, 0, zz);
                if (MiscUtils.canSeeSky(this.func_145831_w(), other, false, true)) continue;
                return false;
            }
        }
        return MiscUtils.canSeeSky(this.func_145831_w(), this.func_174877_v().func_177984_a(), true, false);
    }

    private Entity createNewObservatoryEntity() {
        this.entityHelperRef = null;
        this.entityIdServerRef = null;
        EntityObservatoryHelper helper = new EntityObservatoryHelper(this.field_145850_b, this.field_174879_c);
        helper.func_70080_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.1, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0f, 0.0f);
        this.field_145850_b.func_72838_d((Entity)helper);
        this.entityHelperRef = helper.func_110124_au();
        this.entityIdServerRef = helper.func_145782_y();
        return helper;
    }

    @Nullable
    private Entity resolveEntity(UUID entityUUID) {
        if (entityUUID == null) {
            return null;
        }
        for (Entity e : this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-3, -1, -3), this.field_174879_c.func_177982_a(3, 2, 3)))) {
            if (!e.func_110124_au().equals(entityUUID)) continue;
            this.entityIdServerRef = e.func_145782_y();
            return e;
        }
        return null;
    }

    @Nullable
    public Entity findRideableObservatoryEntity() {
        if (this.entityHelperRef == null || this.entityIdServerRef == null) {
            return null;
        }
        return this.field_145850_b.func_73045_a(this.entityIdServerRef.intValue());
    }

    @Nullable
    public UUID getEntityHelperRef() {
        return this.entityHelperRef;
    }

    public void setEntityHelperRef(UUID entityHelperRef) {
        this.entityHelperRef = entityHelperRef;
        this.markForUpdate();
    }

    public void updatePitchYaw(float pitch, float prevPitch, float yaw, float prevYaw) {
        this.observatoryPitch = pitch;
        this.prevObservatoryPitch = prevPitch;
        this.observatoryYaw = yaw;
        this.prevObservatoryYaw = prevYaw;
        this.markForUpdate();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.entityHelperRef = compound.func_186855_b("entity") ? compound.func_186857_a("entity") : null;
        this.observatoryYaw = compound.func_74760_g("oYaw");
        this.observatoryPitch = compound.func_74760_g("oPitch");
        this.prevObservatoryYaw = compound.func_74760_g("oYawPrev");
        this.prevObservatoryPitch = compound.func_74760_g("oPitchPrev");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        if (this.entityHelperRef != null) {
            compound.func_186854_a("entity", this.entityHelperRef);
        }
        compound.func_74776_a("oYaw", this.observatoryYaw);
        compound.func_74776_a("oPitch", this.observatoryPitch);
        compound.func_74776_a("oYawPrev", this.prevObservatoryYaw);
        compound.func_74776_a("oPitchPrev", this.prevObservatoryPitch);
    }
}

