/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.capabilities;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import p455w0rdslib.util.CapabilityUtils;
import p455w0rdslib.util.ChunkUtils;

public class CapabilityChunkLoader {
    @CapabilityInject(value=ICLTEHandler.class)
    public static Capability<ICLTEHandler> CAPABILITY_CHUNKLOADER_TE = null;
    @CapabilityInject(value=ICLEntityHandler.class)
    public static Capability<ICLEntityHandler> CAPABILITY_CHUNKLOADER_ENTITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(ICLTEHandler.class, new CapabilityUtils.EmptyStorage(), DefaultCLTEHandler::new);
        CapabilityManager.INSTANCE.register(ICLEntityHandler.class, (Capability.IStorage)new StorageEntity(), DefaultCLEntityHandler::new);
    }

    public static ICLTEHandler get(TileEntity tile) {
        if (tile.hasCapability(CAPABILITY_CHUNKLOADER_TE, null)) {
            return (ICLTEHandler)tile.getCapability(CAPABILITY_CHUNKLOADER_TE, null);
        }
        return null;
    }

    public static ICLEntityHandler get(Entity entity) {
        if (entity.hasCapability(CAPABILITY_CHUNKLOADER_ENTITY, null)) {
            return (ICLEntityHandler)entity.getCapability(CAPABILITY_CHUNKLOADER_ENTITY, null);
        }
        return null;
    }

    public static class ProviderEntity
    implements ICapabilitySerializable<NBTTagCompound> {
        ICLEntityHandler instance = (ICLEntityHandler)CAPABILITY_CHUNKLOADER_ENTITY.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CAPABILITY_CHUNKLOADER_ENTITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CAPABILITY_CHUNKLOADER_ENTITY.cast((Object)this.instance) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)CAPABILITY_CHUNKLOADER_ENTITY.getStorage().writeNBT(CAPABILITY_CHUNKLOADER_ENTITY, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            CAPABILITY_CHUNKLOADER_ENTITY.getStorage().readNBT(CAPABILITY_CHUNKLOADER_ENTITY, (Object)this.instance, null, (NBTBase)nbt);
        }
    }

    public static class ProviderTE
    implements ICapabilityProvider {
        ICLTEHandler instance;
        TileEntity tile;

        public ProviderTE(TileEntity te) {
            this.tile = te;
            this.instance = new DefaultCLTEHandler();
            this.instance.setTileEntity(te);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CAPABILITY_CHUNKLOADER_TE;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CAPABILITY_CHUNKLOADER_TE.cast((Object)this.instance) : null);
        }
    }

    public static class StorageEntity
    implements Capability.IStorage<ICLEntityHandler> {
        public NBTBase writeNBT(Capability<ICLEntityHandler> capability, ICLEntityHandler instance, EnumFacing side) {
            NBTTagCompound properties = new NBTTagCompound();
            NBTTagList ownedchunkloaders = new NBTTagList();
            properties.func_74782_a("ownedchunkloaders", (NBTBase)ownedchunkloaders);
            for (int i = 0; i < instance.getList().size(); ++i) {
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_74772_a("pos" + i, instance.getList().get(i).func_177986_g());
                ownedchunkloaders.func_74742_a((NBTBase)entry);
            }
            return properties;
        }

        public void readNBT(Capability<ICLEntityHandler> capability, ICLEntityHandler instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound properties = (NBTTagCompound)nbt;
            if (properties.func_150297_b("ownedchunkloaders", 9)) {
                NBTTagList ownedchunkloaders = properties.func_150295_c("ownedchunkloaders", 10);
                int count = ownedchunkloaders.func_74745_c();
                for (int i = 0; i < count; ++i) {
                    instance.add(BlockPos.func_177969_a((long)ownedchunkloaders.func_150305_b(i).func_74763_f("pos")));
                }
            }
        }
    }

    public static class DefaultCLEntityHandler
    implements ICLEntityHandler {
        private ArrayList<BlockPos> chunkLoaderList = new ArrayList();

        @Override
        public ArrayList<BlockPos> getList() {
            return this.chunkLoaderList;
        }

        @Override
        public void add(BlockPos pos) {
            this.chunkLoaderList.add(pos);
        }

        @Override
        public void remove(BlockPos pos) {
            this.chunkLoaderList.remove(pos);
        }

        @Override
        public void set(ArrayList<BlockPos> list) {
            this.chunkLoaderList = list;
        }

        @Override
        public int total() {
            return this.chunkLoaderList.size();
        }
    }

    public static class DefaultCLTEHandler
    implements ICLTEHandler {
        TileEntity tile;

        @Override
        public void setTileEntity(TileEntity te) {
            this.tile = te;
        }

        @Override
        public void attachChunkLoader(Object modInstance) {
            if (this.tile != null) {
                ChunkUtils.TicketHandler handler = ChunkUtils.TicketHandler.getInstance();
                FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> handler.load(this.tile.func_145831_w(), this.tile.func_174877_v(), handler.getTicket(modInstance, this.tile.func_145831_w())));
            }
        }

        @Override
        public void detachChunkLoader(Object modInstance) {
            if (this.tile != null) {
                ChunkUtils.TicketHandler handler = ChunkUtils.TicketHandler.getInstance();
                FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> handler.unload(this.tile.func_145831_w(), this.tile.func_174877_v(), handler.getTicket(modInstance, this.tile.func_145831_w())));
            }
        }
    }

    public static interface ICLEntityHandler {
        public ArrayList<BlockPos> getList();

        public void add(BlockPos var1);

        public void remove(BlockPos var1);

        public void set(ArrayList<BlockPos> var1);

        public int total();
    }

    public static interface ICLTEHandler {
        public void setTileEntity(TileEntity var1);

        public void attachChunkLoader(Object var1);

        public void detachChunkLoader(Object var1);
    }
}

