/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.capabilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.tuple.Pair;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.api.client.shader.Light;
import p455w0rdslib.util.CapabilityUtils;
import p455w0rdslib.util.RenderUtils;

public class CapabilityLightEmitter {
    public static final ResourceLocation CAP_LOCATION = new ResourceLocation("p455w0rdslib", "lights_cap");
    private static final Map<Item, Pair<Integer, Pair<Float, Float>>> ITEM_COLOR_MAP = new HashMap<Item, Pair<Integer, Pair<Float, Float>>>();
    private static final Pair<Integer, Pair<Float, Float>> NULL_COLOR = Pair.of((Object)0, (Object)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
    private static final Capability.IStorage<ILightEmitter> STORAGE = new CapabilityUtils.EmptyStorage<ILightEmitter>();
    @CapabilityInject(value=ILightEmitter.class)
    public static Capability<ILightEmitter> LIGHT_EMITTER_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(ILightEmitter.class, STORAGE, () -> new DummyLightEmitter());
    }

    public static boolean checkCap(Capability<?> capability) {
        return !LibGlobals.Mods.ALBEDO.isLoaded() && capability == LIGHT_EMITTER_CAPABILITY;
    }

    public static boolean hasCap(TileEntity tile) {
        return tile != null && tile.func_145831_w() != null && tile.func_145838_q() != null && tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177230_c() == tile.func_145838_q() && tile.hasCapability(LIGHT_EMITTER_CAPABILITY, null);
    }

    public static boolean hasCap(Entity entity) {
        return entity.hasCapability(LIGHT_EMITTER_CAPABILITY, null);
    }

    public static boolean hasCap(ItemStack stack) {
        return stack.hasCapability(LIGHT_EMITTER_CAPABILITY, null);
    }

    public static List<Light> getLights(TileEntity tile) {
        return CapabilityLightEmitter.hasCap(tile) ? ((ILightEmitter)tile.getCapability(LIGHT_EMITTER_CAPABILITY, null)).emitLight(new ArrayList<Light>(), tile) : Collections.EMPTY_LIST;
    }

    public static List<Light> getLights(Entity entity) {
        return CapabilityLightEmitter.hasCap(entity) ? ((ILightEmitter)entity.getCapability(LIGHT_EMITTER_CAPABILITY, null)).emitLight(new ArrayList<Light>(), entity) : Collections.EMPTY_LIST;
    }

    public static List<Light> getLights(ItemStack stack, Entity entity) {
        if (stack == null || entity == null || !CapabilityLightEmitter.hasCap(stack) || stack.func_77973_b().getRegistryName().func_110624_b().equals("minecraft") && !LibGlobals.ConfigOptions.ENABLE_VANILLA_LIGHT_EFFECTS) {
            return Collections.EMPTY_LIST;
        }
        ILightEmitter cap = (ILightEmitter)stack.getCapability(LIGHT_EMITTER_CAPABILITY, null);
        if (cap == null) {
            return Collections.EMPTY_LIST;
        }
        return cap.emitLight(new ArrayList<Light>(), entity);
    }

    public static ICapabilityProvider getDummyProvider() {
        return DummyLightProvider.DUMMY_INSTANCE;
    }

    public static <T> T getDummyCapability() {
        return (T)LIGHT_EMITTER_CAPABILITY.cast((Object)new DummyLightEmitter());
    }

    public static <T> T getVanillaStackCapability(ItemStack stack) {
        if ((Integer)CapabilityLightEmitter.getColorForStack(stack).getLeft() != 0) {
            return (T)LIGHT_EMITTER_CAPABILITY.cast((Object)new StackLightEmitter(stack){

                @Override
                public List<Light> emitLight(List<Light> lights, Entity entity) {
                    Vec3i c = RenderUtils.hexToRGB((Integer)CapabilityLightEmitter.getColorForStack(this.stack).getLeft());
                    lights.add(Light.builder().pos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v).color(c.func_177958_n(), c.func_177956_o(), c.func_177952_p(), ((Float)((Pair)CapabilityLightEmitter.getColorForStack(this.stack).getRight()).getRight()).floatValue()).radius(((Float)((Pair)CapabilityLightEmitter.getColorForStack(this.stack).getRight()).getLeft()).floatValue()).intensity(5.0f).build());
                    return lights;
                }
            });
        }
        return null;
    }

    public static ICapabilityProvider getVanillaStackProvider(final ItemStack stack) {
        return new ICapabilityProvider(){

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return CapabilityLightEmitter.checkCap(capability);
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return this.hasCapability(capability, null) ? (T)CapabilityLightEmitter.getVanillaStackCapability(stack) : null;
            }
        };
    }

    public static Pair<Integer, Pair<Float, Float>> getColorForStack(ItemStack stack) {
        if (LibGlobals.ConfigOptions.ENABLE_VANILLA_LIGHT_EFFECTS) {
            int meta;
            if (ITEM_COLOR_MAP.isEmpty()) {
                CapabilityLightEmitter.genColorMap();
            }
            if ((meta = stack.func_77960_j()) >= 16) {
                meta = 0;
            }
            if (ITEM_COLOR_MAP.containsKey(stack.func_77973_b())) {
                return ITEM_COLOR_MAP.get(stack.func_77973_b());
            }
        }
        return NULL_COLOR;
    }

    private static void genColorMap() {
        ITEM_COLOR_MAP.clear();
        ITEM_COLOR_MAP.put(Items.field_151129_at, (Pair<Integer, Pair<Float, Float>>)Pair.of((Object)-43776, (Object)Pair.of((Object)Float.valueOf(4.0f), (Object)Float.valueOf(1.0f))));
    }

    public static interface ILightEmitter {
        default public List<Light> emitLight(List<Light> lights, Entity entity) {
            return Collections.EMPTY_LIST;
        }

        default public List<Light> emitLight(List<Light> lights, TileEntity entity) {
            return Collections.EMPTY_LIST;
        }
    }

    public static class TileLightProvider
    extends DummyLightProvider {
        public TileLightProvider(TileEntity tile) {
            super(new TileLightEmitter(tile));
        }
    }

    public static class StackLightProvider
    extends DummyLightProvider {
        public StackLightProvider(ItemStack stack) {
            super(new StackLightEmitter(stack));
        }
    }

    public static class EntityLightProvider
    extends DummyLightProvider {
        public EntityLightProvider(Entity entity) {
            super(new EntityLightEmitter(entity));
        }
    }

    public static class TileLightEmitter
    extends DummyLightEmitter {
        TileEntity tile;

        public TileLightEmitter(TileEntity tile) {
            this.tile = tile;
        }

        @Override
        public List<Light> emitLight(List<Light> lights, TileEntity entity) {
            return Collections.EMPTY_LIST;
        }
    }

    public static class StackLightEmitter
    extends DummyLightEmitter {
        ItemStack stack;

        public StackLightEmitter(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public List<Light> emitLight(List<Light> lights, Entity entity) {
            return Collections.EMPTY_LIST;
        }
    }

    public static class EntityLightEmitter
    extends DummyLightEmitter {
        Entity entity;

        public EntityLightEmitter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public List<Light> emitLight(List<Light> lights, Entity entity) {
            return Collections.EMPTY_LIST;
        }
    }

    public static class DummyLightProvider
    implements ICapabilityProvider {
        ILightEmitter emitter;
        public static DummyLightProvider DUMMY_INSTANCE = new DummyLightProvider();

        private DummyLightProvider() {
            this((ILightEmitter)CapabilityLightEmitter.getDummyCapability());
        }

        public DummyLightProvider(ILightEmitter emitter) {
            this.emitter = emitter;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return CapabilityLightEmitter.checkCap(capability);
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, null) ? LIGHT_EMITTER_CAPABILITY.cast((Object)this.emitter) : null);
        }
    }

    private static class DummyLightEmitter
    implements ILightEmitter {
        private DummyLightEmitter() {
        }
    }
}

