/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.varia.BlockTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import romelo333.notenoughwands.ConfigSetup;
import romelo333.notenoughwands.Items.BlackListSettings;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.ProtectedBlocks;
import romelo333.notenoughwands.varia.Tools;

public class SwappingWand
extends GenericWand {
    public static final int MODE_FIRST = 0;
    public static final int MODE_3X3 = 0;
    public static final int MODE_5X5 = 1;
    public static final int MODE_7X7 = 2;
    public static final int MODE_SINGLE = 3;
    public static final int MODE_LAST = 3;
    private float hardnessDistance = 35.0f;
    public static final String[] descriptions = new String[]{"3x3", "5x5", "7x7", "single"};

    public SwappingWand() {
        this.setup("swapping_wand").xpUsage(1).loot(5);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg, 2000, 100000, 500, 200000, 200, 500000);
        this.hardnessDistance = (float)cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_hardnessDistance", (double)this.hardnessDistance, "How far away the hardness can be to allow swapping (100 means basically everything allowed)").getDouble();
    }

    @Override
    public void toggleMode(EntityPlayer player, ItemStack stack) {
        int mode = this.getMode(stack);
        if (++mode > 3) {
            mode = 0;
        }
        Tools.notify(player, "Switched to " + descriptions[mode] + " mode");
        Tools.getTagCompound(stack).func_74768_a("mode", mode);
    }

    @Override
    public void func_77624_a(ItemStack stack, World player, List<String> list, ITooltipFlag b) {
        super.func_77624_a(stack, player, list, b);
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            list.add(TextFormatting.RED + "No selected block");
        } else if (SwappingWand.isSwappingWithOffHand(stack)) {
            list.add(TextFormatting.GREEN + "Will swap with block in offhand");
        } else {
            int id = compound.func_74762_e("block");
            Block block = (Block)Block.field_149771_c.func_148754_a(id);
            if (block != Blocks.field_150350_a) {
                int meta = compound.func_74762_e("meta");
                String name = Tools.getBlockName(block, meta);
                list.add(TextFormatting.GREEN + "Selected block: " + name);
                list.add(TextFormatting.GREEN + "Mode: " + descriptions[compound.func_74762_e("mode")]);
            }
        }
        list.add("Sneak right click to select a block.");
        list.add("Right click in empty air to select 'offhand' mode.");
        list.add("Right click on block to replace.");
        this.showModeKeyDescription(list, "switch mode");
    }

    private static boolean isSwappingWithOffHand(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            return false;
        }
        return compound.func_74764_b("offhand");
    }

    private static void enableSwappingWithOffHand(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        compound.func_74757_a("offhand", true);
    }

    private static void disableSwappingWithOffHand(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            return;
        }
        compound.func_82580_o("offhand");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            if (SwappingWand.isSwappingWithOffHand(heldItem)) {
                SwappingWand.disableSwappingWithOffHand(heldItem);
                if (worldIn.field_72995_K) {
                    Tools.notify(playerIn, "Switched to swapping with selected block");
                }
            } else {
                SwappingWand.enableSwappingWithOffHand(heldItem);
                if (worldIn.field_72995_K) {
                    Tools.notify(playerIn, "Switched to swapping with block in offhand");
                }
            }
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                this.selectBlock(stack, player, world, pos);
            } else {
                this.placeBlock(stack, player, world, pos, side);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private void placeBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        float hardness;
        int meta;
        Block block;
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            Tools.error(player, "First select a block by sneaking");
            return;
        }
        if (SwappingWand.isSwappingWithOffHand(stack)) {
            ItemStack off = player.func_184592_cb();
            if (off.func_190926_b()) {
                Tools.error(player, "You need to hold a block in your offhand!");
                return;
            }
            if (!(off.func_77973_b() instanceof ItemBlock)) {
                Tools.error(player, "The item in your offhand cannot be placed!");
                return;
            }
            ItemBlock itemBlock = (ItemBlock)off.func_77973_b();
            block = itemBlock.func_179223_d();
            meta = itemBlock.getDamage(off);
            IBlockState s = block.func_176203_a(meta);
            hardness = s.func_185887_b(world, pos);
        } else {
            int id = tagCompound.func_74762_e("block");
            block = (Block)Block.field_149771_c.func_148754_a(id);
            meta = tagCompound.func_74762_e("meta");
            hardness = tagCompound.func_74760_g("hardness");
        }
        IBlockState oldState = world.func_180495_p(pos);
        Block oldblock = oldState.func_177230_c();
        double cost = BlackListSettings.getBlacklistCost(oldblock);
        if (cost <= (double)0.001f) {
            Tools.error(player, "It is illegal to swap this block");
            return;
        }
        int oldmeta = oldblock.func_176201_c(oldState);
        float blockHardness = oldblock.func_176195_g(oldState, world, pos);
        if (block == oldblock && meta == oldmeta) {
            return;
        }
        if (blockHardness < -0.1f) {
            Tools.error(player, "This block cannot be swapped!");
            return;
        }
        if (!player.func_184812_l_() && Math.abs(hardness - blockHardness) >= this.hardnessDistance) {
            Tools.error(player, "The hardness of this blocks differs too much to swap!");
            return;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, pos)) {
            Tools.error(player, "This block is protected. You cannot replace it!");
            return;
        }
        Set<BlockPos> coordinates = this.findSuitableBlocks(stack, world, side, pos, oldblock, oldmeta);
        boolean notenough = false;
        for (BlockPos coordinate : coordinates) {
            if (!this.checkUsage(stack, player, 1.0f)) {
                return;
            }
            ItemStack consumed = Tools.consumeInventoryItem(Item.func_150898_a((Block)block), meta, player.field_71071_by, player);
            if (!consumed.func_190926_b()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemStack oldblockItem = oldblock.getPickBlock(oldState, null, world, pos, player);
                    Tools.giveItem(world, player, pos, oldblockItem);
                }
                Tools.playSound(world, block.func_185467_w().func_185844_d(), (double)coordinate.func_177958_n(), (double)coordinate.func_177956_o(), (double)coordinate.func_177952_p(), 1.0, 1.0);
                BlockSnapshot blocksnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)coordinate);
                world.func_175698_g(coordinate);
                BlockTools.placeStackAt((EntityPlayer)player, (ItemStack)consumed, (World)world, (BlockPos)coordinate, null);
                if (ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)blocksnapshot, (EnumFacing)EnumFacing.UP, (EnumHand)EnumHand.MAIN_HAND).isCanceled()) {
                    blocksnapshot.restore(true, false);
                    if (!player.field_71075_bZ.field_75098_d) {
                        Tools.giveItem(world, player, player.func_180425_c(), consumed);
                    }
                }
                player.field_71070_bA.func_75142_b();
                this.registerUsage(stack, player, 1.0f);
                continue;
            }
            notenough = true;
        }
        if (notenough) {
            Tools.error(player, "You don't have the right block");
        }
    }

    private void selectBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack item = block.getPickBlock(state, null, world, pos, player);
        int meta = item.func_77960_j();
        NBTTagCompound tagCompound = Tools.getTagCompound(stack);
        String name = Tools.getBlockName(block, meta);
        if (name == null) {
            Tools.error(player, "You cannot select this block!");
        } else {
            double cost = BlackListSettings.getBlacklistCost(block);
            if (cost <= (double)0.001f) {
                Tools.error(player, "It is illegal to swap this block");
                return;
            }
            int id = Block.field_149771_c.func_148757_b((Object)block);
            tagCompound.func_74768_a("block", id);
            tagCompound.func_74768_a("meta", meta);
            float hardness = block.func_176195_g(state, world, pos);
            tagCompound.func_74776_a("hardness", hardness);
            Tools.notify(player, "Selected block: " + name);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(RenderWorldLastEvent evt, EntityPlayerSP player, ItemStack wand) {
        IBlockState state;
        Block block;
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver != null && mouseOver.func_178782_a() != null && mouseOver.field_178784_b != null && (block = (state = player.func_130014_f_().func_180495_p(mouseOver.func_178782_a())).func_177230_c()) != null && block.func_149688_o(state) != Material.field_151579_a) {
            int meta = block.func_176201_c(state);
            int wandId = Tools.getTagCompound(wand).func_74762_e("block");
            Block wandBlock = (Block)Block.field_149771_c.func_148754_a(wandId);
            int wandMeta = Tools.getTagCompound(wand).func_74762_e("meta");
            if (wandBlock == block && wandMeta == meta) {
                return;
            }
            Set<BlockPos> coordinates = this.findSuitableBlocks(wand, player.func_130014_f_(), mouseOver.field_178784_b, mouseOver.func_178782_a(), block, meta);
            SwappingWand.renderOutlines(evt, player, coordinates, 200, 230, 180);
        }
    }

    private Set<BlockPos> findSuitableBlocks(ItemStack stack, World world, EnumFacing sideHit, BlockPos pos, Block centerBlock, int centerMeta) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        int mode = this.getMode(stack);
        int dim = 0;
        switch (mode) {
            case 3: {
                coordinates.add(pos);
                return coordinates;
            }
            case 0: {
                dim = 1;
                break;
            }
            case 1: {
                dim = 2;
                break;
            }
            case 2: {
                dim = 3;
            }
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (sideHit) {
            case UP: 
            case DOWN: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, dx, y, dz, centerBlock, centerMeta, coordinates);
                    }
                }
                break;
            }
            case SOUTH: 
            case NORTH: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dy = y - dim; dy <= y + dim; ++dy) {
                        this.checkAndAddBlock(world, dx, dy, z, centerBlock, centerMeta, coordinates);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int dy = y - dim; dy <= y + dim; ++dy) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, x, dy, dz, centerBlock, centerMeta, coordinates);
                    }
                }
                break;
            }
        }
        return coordinates;
    }

    private void checkAndAddBlock(World world, int x, int y, int z, Block centerBlock, int centerMeta, Set<BlockPos> coordinates) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == centerBlock && state.func_177230_c().func_176201_c(state) == centerMeta) {
            coordinates.add(pos);
        }
    }

    private int getMode(ItemStack stack) {
        return Tools.getTagCompound(stack).func_74762_e("mode");
    }
}

