/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.necronomicon.condition;

import com.shinoow.abyssalcraft.api.necronomicon.condition.IConditionProcessor;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConditionProcessorRegistry {
    private final Map<Integer, IConditionProcessor> processors = new HashMap<Integer, IConditionProcessor>();
    private final Logger logger = LogManager.getLogger((String)"ConditionProcessorRegistry");
    private static final ConditionProcessorRegistry INSTANCE = new ConditionProcessorRegistry();

    public static ConditionProcessorRegistry instance() {
        return INSTANCE;
    }

    private ConditionProcessorRegistry() {
    }

    public void registerProcessor(int type, IConditionProcessor processor) {
        if (type > -1) {
            if (this.processors.putIfAbsent(type, processor) != null) {
                this.logger.log(Level.ERROR, "Processor already registed for type {}", (Object)type);
            }
        } else {
            this.logger.log(Level.ERROR, "Invalid type: {}", (Object)type);
        }
    }

    public IConditionProcessor getProcessor(int type) {
        return this.processors.getOrDefault(type, (condition, cap, player) -> false);
    }
}

