/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.ritual;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.ritual.EnumRitualParticle;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconCreationRitual;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NecronomiconInfusionRitual
extends NecronomiconCreationRitual {
    private String[] tags;

    public NecronomiconInfusionRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean requiresSacrifice, ItemStack item, Object sacrifice, Object ... offerings) {
        super(unlocalizedName, bookType, dimension, requiredEnergy, requiresSacrifice, item, offerings);
        this.sacrifice = sacrifice;
        this.setRitualParticle(EnumRitualParticle.ITEM_SMOKE_COMBO);
    }

    public NecronomiconInfusionRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, ItemStack item, Object sacrifice, Object ... offerings) {
        this(unlocalizedName, bookType, dimension, requiredEnergy, false, item, sacrifice, offerings);
    }

    public NecronomiconInfusionRitual(String unlocalizedName, int bookType, float requiredEnergy, ItemStack item, Object sacrifice, Object ... offerings) {
        this(unlocalizedName, bookType, -1, requiredEnergy, item, sacrifice, offerings);
    }

    public NecronomiconInfusionRitual setTags(String ... strings) {
        this.tags = strings;
        return this;
    }

    @Override
    public boolean canCompleteRitual(World world, BlockPos pos, EntityPlayer player) {
        TileEntity altar = world.func_175625_s(pos);
        NBTTagCompound compound = new NBTTagCompound();
        altar.func_189515_b(compound);
        NBTTagCompound nbtItem = compound.func_74775_l("Item");
        return APIUtils.areObjectsEqual(new ItemStack(nbtItem), this.sacrifice, false);
    }

    @Override
    protected void completeRitualServer(World world, BlockPos pos, EntityPlayer player) {
        if (this.canCompleteRitual(world, pos, player)) {
            ItemStack stack;
            NBTTagCompound compound;
            TileEntity altar;
            NBTTagCompound data = new NBTTagCompound();
            if (this.tags != null && this.tags.length > 0) {
                altar = world.func_175625_s(pos);
                compound = new NBTTagCompound();
                altar.func_189515_b(compound);
                stack = new ItemStack(compound.func_74775_l("Item"));
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                for (String s : this.tags) {
                    if (!stack.func_77978_p().func_74764_b(s)) continue;
                    data.func_74782_a(s, stack.func_77978_p().func_74781_a(s));
                }
            }
            super.completeRitualServer(world, pos, player);
            if (!data.func_82582_d()) {
                altar = world.func_175625_s(pos);
                compound = new NBTTagCompound();
                altar.func_189515_b(compound);
                stack = new ItemStack(compound.func_74775_l("Item"));
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                for (String e : this.tags) {
                    if (!data.func_74764_b(e)) continue;
                    stack.func_77978_p().func_74782_a(e, data.func_74781_a(e));
                }
                NBTTagCompound item = new NBTTagCompound();
                stack.func_77955_b(item);
                compound.func_74782_a("Item", (NBTBase)item);
                altar.func_145839_a(compound);
            }
        }
    }

    @Override
    protected void completeRitualClient(World world, BlockPos pos, EntityPlayer player) {
    }
}

