/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.spell;

import com.shinoow.abyssalcraft.api.necronomicon.condition.DefaultCondition;
import com.shinoow.abyssalcraft.api.necronomicon.condition.IUnlockCondition;
import com.shinoow.abyssalcraft.api.spell.SpellEnum;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public abstract class Spell {
    private Object[] reagents = new Object[5];
    private ItemStack parchment = ItemStack.field_190927_a;
    private final String unlocalizedName;
    private int bookType;
    private int color;
    private float requiredEnergy;
    private boolean nbtSensitive;
    private boolean requiresCharging;
    private Spell parent;
    private ResourceLocation glyph;
    private IUnlockCondition condition = new DefaultCondition();
    private SpellEnum.ScrollType scrollType = SpellEnum.ScrollType.BASIC;

    public Spell(String unlocalizedName, int bookType, float requiredEnergy, Object ... reagents) {
        this.unlocalizedName = unlocalizedName;
        this.bookType = bookType;
        this.requiredEnergy = requiredEnergy;
        if (reagents.length < 5) {
            this.reagents = new Object[reagents.length];
            for (int i = 0; i < reagents.length; ++i) {
                this.reagents[i] = reagents[i];
            }
        } else {
            this.reagents = reagents;
        }
    }

    public Spell(String unlocalizedName, float requiredEnergy, Object ... reagents) {
        this(unlocalizedName, 0, requiredEnergy, reagents);
    }

    public Spell setParchment(ItemStack parchment) {
        this.parchment = parchment;
        return this;
    }

    public Spell setColor(int color) {
        this.color = color;
        return this;
    }

    public Spell setNBTSensitive() {
        this.nbtSensitive = true;
        return this;
    }

    public Spell setRequiresCharging() {
        this.requiresCharging = true;
        return this;
    }

    public Spell setParent(Spell parent) {
        this.parent = parent;
        return this;
    }

    public Spell setGlyph(ResourceLocation glyph) {
        this.glyph = glyph;
        return this;
    }

    public Spell setUnlockCondition(IUnlockCondition condition) {
        this.condition = condition;
        return this;
    }

    public Spell setScrollType(SpellEnum.ScrollType scrollType) {
        this.scrollType = scrollType;
        return this;
    }

    public Object[] getReagents() {
        return this.reagents;
    }

    public ItemStack getParchment() {
        return this.parchment;
    }

    public int getBookType() {
        return this.bookType;
    }

    public int getColor() {
        return this.color;
    }

    public float getReqEnergy() {
        return this.requiredEnergy;
    }

    public boolean requiresCharging() {
        return this.requiresCharging;
    }

    public Spell getParent() {
        return this.parent;
    }

    public ResourceLocation getSpellGlyph() {
        return this.glyph;
    }

    public IUnlockCondition getUnlockCondition() {
        return this.condition;
    }

    public SpellEnum.ScrollType getScrollType() {
        return this.scrollType;
    }

    public String getUnlocalizedName() {
        return "ac.spell." + this.unlocalizedName;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)this.getUnlocalizedName());
    }

    public String getDescription() {
        return I18n.func_74838_a((String)(this.getUnlocalizedName() + ".desc"));
    }

    public boolean isNBTSensitive() {
        return this.nbtSensitive;
    }

    public abstract boolean canCastSpell(World var1, BlockPos var2, EntityPlayer var3);

    public void castSpell(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            this.castSpellServer(world, pos, player);
        }
        if (world.field_72995_K) {
            this.castSpellClient(world, pos, player);
        }
    }

    protected abstract void castSpellClient(World var1, BlockPos var2, EntityPlayer var3);

    protected abstract void castSpellServer(World var1, BlockPos var2, EntityPlayer var3);
}

