/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.shinoow.abyssalcraft.api.energy.IEnergyContainer;
import com.shinoow.abyssalcraft.api.energy.IEnergyContainerItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityEnergyContainer
extends TileEntity
implements IEnergyContainer,
ITickable,
IInventory {
    private float energy;
    private NonNullList<ItemStack> containerItemStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74760_g("PotEnergy");
        this.containerItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbttagcompound, this.containerItemStacks);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74776_a("PotEnergy", this.energy);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbttagcompound, this.containerItemStacks);
        return nbttagcompound;
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.field_175730_i.remove(this);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_73660_a() {
        ItemStack output;
        ItemStack input = this.func_70301_a(0);
        if (!input.func_190926_b() && input.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)input.func_77973_b()).canTransferPE(input) && this.canAcceptPE()) {
            this.addEnergy(((IEnergyContainerItem)input.func_77973_b()).consumeEnergy(input, 1.0f));
        }
        if (!(output = this.func_70301_a(1)).func_190926_b() && output.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)output.func_77973_b()).canAcceptPE(output) && this.canTransferPE()) {
            ((IEnergyContainerItem)output.func_77973_b()).addEnergy(output, this.consumeEnergy(1.0f));
        }
    }

    @Override
    public float getContainedEnergy() {
        return this.energy;
    }

    @Override
    public int getMaxEnergy() {
        return 10000;
    }

    @Override
    public void addEnergy(float energy) {
        this.energy += energy;
        if (this.energy > (float)this.getMaxEnergy()) {
            this.energy = this.getMaxEnergy();
        }
    }

    @Override
    public float consumeEnergy(float energy) {
        if (energy < this.energy) {
            this.energy -= energy;
            return energy;
        }
        float ret = this.energy;
        this.energy = 0.0f;
        return ret;
    }

    @Override
    public boolean canAcceptPE() {
        return this.getContainedEnergy() < (float)this.getMaxEnergy();
    }

    @Override
    public boolean canTransferPE() {
        return this.getContainedEnergy() > 0.0f;
    }

    @Override
    public TileEntity getContainerTile() {
        return this;
    }

    public String func_70005_c_() {
        return "container.abyssalcraft.energycontainer";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.containerItemStacks.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.containerItemStacks.get(index);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return ItemStackHelper.func_188382_a(this.containerItemStacks, (int)var1, (int)var2);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.containerItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containerItemStacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof IEnergyContainerItem;
    }

    public int func_174887_a_(int id) {
        if (id == 0) {
            return (int)this.energy;
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.energy = value;
        }
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.containerItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

