/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.shinoow.abyssalcraft.api.biome.ACBiomes;
import com.shinoow.abyssalcraft.api.biome.IDarklandsBiome;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.energy.EnergyEnum;
import com.shinoow.abyssalcraft.api.energy.IEnergyManipulator;
import com.shinoow.abyssalcraft.api.energy.PEUtils;
import com.shinoow.abyssalcraft.api.energy.disruption.DisruptionHandler;
import com.shinoow.abyssalcraft.common.blocks.BlockACBrick;
import com.shinoow.abyssalcraft.common.blocks.BlockRitualAltar;
import com.shinoow.abyssalcraft.common.items.ItemStoneTablet;
import com.shinoow.abyssalcraft.common.util.BiomeUtil;
import com.shinoow.abyssalcraft.init.BlockHandler;
import com.shinoow.abyssalcraft.lib.ACConfig;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityEnergyDepositioner
extends TileEntity
implements IEnergyManipulator,
ITickable,
ISidedInventory {
    private int activationTimer;
    private EnergyEnum.AmplifierType currentAmplifier;
    private int tolerance;
    private float energy;
    private int processingTime;
    private ItemStack processingStack = ItemStack.field_190927_a;
    private NonNullList<ItemStack> containerItemStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.activationTimer = nbttagcompound.func_74762_e("ActivationTimer");
        this.tolerance = nbttagcompound.func_74762_e("Tolerance");
        this.energy = nbttagcompound.func_74760_g("PotEnergy");
        PEUtils.readManipulatorNBT(this, nbttagcompound);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbttagcompound, this.containerItemStacks);
        this.processingTime = nbttagcompound.func_74762_e("ProcessingTime");
        this.processingStack = new ItemStack(nbttagcompound.func_74775_l("ProcessingStack"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("ActivationTimer", this.activationTimer);
        nbttagcompound.func_74768_a("Tolerance", this.tolerance);
        nbttagcompound.func_74776_a("PotEnergy", this.energy);
        PEUtils.writeManipulatorNBT(this, nbttagcompound);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbttagcompound, this.containerItemStacks);
        nbttagcompound.func_74768_a("ProcessingTime", this.processingTime);
        NBTTagCompound nbtItem = new NBTTagCompound();
        if (!this.processingStack.func_190926_b()) {
            this.processingStack.func_77955_b(nbtItem);
        }
        nbttagcompound.func_74782_a("ProcessingStack", (NBTBase)nbtItem);
        return nbttagcompound;
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.field_175730_i.remove(this);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Override
    public float getEnergyQuanta() {
        float f;
        float f2 = f = this.isActive() ? 20.0f * Math.max(this.getAmplifier(EnergyEnum.AmplifierType.POWER), 1.0f) : 15.0f;
        if (f < this.energy) {
            this.energy -= f;
            this.func_70296_d();
            return f;
        }
        float ret = this.energy;
        this.energy = 0.0f;
        this.func_70296_d();
        return ret;
    }

    @Override
    public void setActive(EnergyEnum.AmplifierType amp, EnergyEnum.DeityType deity) {
        if (!this.isActive()) {
            this.activationTimer = 1200;
            this.setActiveAmplifier(amp);
        }
    }

    @Override
    public boolean isActive() {
        return this.activationTimer > 0;
    }

    @Override
    public EnergyEnum.DeityType getDeity(IBlockState state) {
        return null;
    }

    @Override
    public float getAmplifier(EnergyEnum.AmplifierType type) {
        if (type == this.currentAmplifier) {
            switch (type) {
                case DURATION: {
                    return 2.0f;
                }
                case POWER: {
                    return 1.5f;
                }
                case RANGE: {
                    return 4.0f;
                }
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public EnergyEnum.DeityType getActiveDeity() {
        return null;
    }

    @Override
    public EnergyEnum.AmplifierType getActiveAmplifier() {
        return this.currentAmplifier;
    }

    @Override
    public void setActiveDeity(EnergyEnum.DeityType deity) {
    }

    @Override
    public void setActiveAmplifier(EnergyEnum.AmplifierType amplifier) {
        this.currentAmplifier = amplifier;
    }

    @Override
    public void addTolerance(int num) {
        this.tolerance += num;
    }

    @Override
    public boolean canTransferPE() {
        return this.energy > 0.0f;
    }

    @Override
    public int getTolerance() {
        return this.tolerance;
    }

    @Override
    public void disrupt() {
        this.tolerance = 0;
        if (!ACConfig.no_disruptions) {
            this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), true));
            DisruptionHandler.instance().generateDisruption(EnergyEnum.DeityType.values()[this.field_145850_b.field_73012_v.nextInt(EnergyEnum.DeityType.values().length)], this.field_145850_b, this.field_174879_c, this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(16.0, 16.0, 16.0)));
        }
    }

    public float getContainedEnergy() {
        return this.energy;
    }

    public void func_73660_a() {
        if (this.isActive()) {
            --this.activationTimer;
            this.field_145850_b.func_175688_a(EnumParticleTypes.PORTAL, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.9, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
        } else {
            PEUtils.clearManipulatorData(this);
        }
        boolean flag = false;
        if (this.canProcess()) {
            ++this.processingTime;
            this.energy += this.drainPEFromInput();
            if (this.energy > 10000.0f) {
                this.energy = 10000.0f;
            }
            if (this.processingTime == 200) {
                this.processingTime = 0;
                this.processItem();
                flag = true;
            }
        } else {
            this.processingTime = 0;
        }
        if (flag) {
            this.func_70296_d();
        }
        if (PEUtils.checkForAdjacentManipulators(this.field_145850_b, this.field_174879_c)) {
            PEUtils.transferPEToCollectors(this.field_145850_b, this.field_174879_c, this, (int)this.getAmplifier(EnergyEnum.AmplifierType.RANGE) / 2);
        }
        if (this.tolerance >= 100) {
            this.disrupt();
        }
    }

    private boolean canProcess() {
        if (!this.processingStack.func_190926_b()) {
            return true;
        }
        if (((ItemStack)this.containerItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack stack = (ItemStack)this.containerItemStacks.get(0);
        if (stack.func_77973_b() instanceof ItemStoneTablet && !((ItemStoneTablet)stack.func_77973_b()).isCursed(stack) && ((ItemStoneTablet)stack.func_77973_b()).hasInventory(stack)) {
            this.processingStack = this.func_70304_b(0);
        }
        return !this.processingStack.func_190926_b();
    }

    private float drainPEFromInput() {
        if (this.processingStack.func_190926_b()) {
            return 0.0f;
        }
        if (!this.processingStack.func_77942_o()) {
            return 0.0f;
        }
        float f = this.processingStack.func_77978_p().func_74760_g("PotEnergy");
        return f / 200.0f;
    }

    private void processItem() {
        float n = 0.0f;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = this.field_174879_c.func_177958_n() - 8; x < this.field_174879_c.func_177958_n() + 9; ++x) {
            for (int z = this.field_174879_c.func_177952_p() - 8; z < this.field_174879_c.func_177952_p() + 9; ++z) {
                BlockPos pos1 = new BlockPos(x, 0, z);
                if (this.field_145850_b.func_180494_b(pos1) instanceof IDarklandsBiome) {
                    n += 1.0f;
                    continue;
                }
                positions.add(pos1);
            }
        }
        for (BlockPos pos1 : positions) {
            if ((float)this.field_145850_b.field_73012_v.nextInt(289) > n) continue;
            n += 1.0f;
            for (int y = 0; y < 256; ++y) {
                IBlockState state = this.field_145850_b.func_180495_p(pos1.func_177981_b(y));
                if (state.func_177230_c() == Blocks.field_150348_b) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.stone.func_176223_P());
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150362_t) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darklands_oak_leaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).func_177226_a((IProperty)BlockLeaves.field_176237_a, state.func_177229_b((IProperty)BlockLeaves.field_176237_a)));
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150364_r) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darklands_oak_wood.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, state.func_177229_b((IProperty)BlockLog.field_176299_a)));
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150347_e) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.cobblestone.func_176223_P());
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150417_aV) {
                    switch ((BlockStoneBrick.EnumType)state.func_177229_b((IProperty)BlockStoneBrick.field_176249_a)) {
                        case CHISELED: {
                            this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darkstone_brick.func_176223_P().func_177226_a(BlockACBrick.TYPE, (Comparable)((Object)BlockACBrick.EnumBrickType.CHISELED)));
                            break;
                        }
                        case CRACKED: {
                            this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darkstone_brick.func_176223_P().func_177226_a(BlockACBrick.TYPE, (Comparable)((Object)BlockACBrick.EnumBrickType.CRACKED)));
                            break;
                        }
                        default: {
                            this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darkstone_brick.func_176223_P());
                            break;
                        }
                    }
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150463_bK && ACConfig.darkstone_cobblestone_wall) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darkstone_cobblestone_wall.func_176223_P());
                    continue;
                }
                if (state == ACBlocks.ritual_altar.func_176223_P()) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.ritual_altar.func_176223_P().func_177226_a(BlockRitualAltar.MATERIAL, (Comparable)((Object)BlockRitualAltar.EnumRitualMatType.DARKSTONE_COBBLESTONE)));
                    continue;
                }
                if (state == ACBlocks.ritual_pedestal.func_176223_P()) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.ritual_pedestal.func_176223_P().func_177226_a(BlockRitualAltar.MATERIAL, (Comparable)((Object)BlockRitualAltar.EnumRitualMatType.DARKSTONE_COBBLESTONE)));
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150333_U && state.func_177229_b((IProperty)BlockStoneSlab.field_176556_M) == BlockStoneSlab.EnumType.SMOOTHBRICK && ACConfig.darkstone_brick_slab) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darkstone_brick_slab.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)));
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150333_U && state.func_177229_b((IProperty)BlockStoneSlab.field_176556_M) == BlockStoneSlab.EnumType.COBBLESTONE && ACConfig.darkstone_cobblestone_slab) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darkstone_cobblestone_slab.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)));
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150333_U && state.func_177229_b((IProperty)BlockStoneSlab.field_176556_M) == BlockStoneSlab.EnumType.STONE && ACConfig.darkstone_slab) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darkstone_slab.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)));
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150334_T && state.func_177229_b((IProperty)BlockStoneSlab.field_176556_M) == BlockStoneSlab.EnumType.STONE && ACConfig.darkstone_slab) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), BlockHandler.Darkstoneslab2.func_176223_P());
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150390_bg && ACConfig.darkstone_brick_stairs) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darkstone_brick_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_177226_a((IProperty)BlockStairs.field_176308_b, state.func_177229_b((IProperty)BlockStairs.field_176308_b)));
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150446_ar && ACConfig.darkstone_cobblestone_stairs) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darkstone_cobblestone_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_177226_a((IProperty)BlockStairs.field_176308_b, state.func_177229_b((IProperty)BlockStairs.field_176308_b)));
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150344_f) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darklands_oak_planks.func_176223_P());
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150476_ad && ACConfig.darklands_oak_stairs) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darklands_oak_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_177226_a((IProperty)BlockStairs.field_176308_b, state.func_177229_b((IProperty)BlockStairs.field_176308_b)));
                    continue;
                }
                if (state.func_177230_c() == Blocks.field_150376_bx && ACConfig.darklands_oak_slab) {
                    this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darklands_oak_slab.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)));
                    continue;
                }
                if (state.func_177230_c() != Blocks.field_180407_aO) continue;
                this.field_145850_b.func_175656_a(pos1.func_177981_b(y), ACBlocks.darklands_oak_fence.func_176223_P());
            }
            BiomeUtil.updateBiome(this.field_145850_b, pos1, ACBiomes.darklands);
        }
        if (this.canProcess()) {
            ItemStack stack = this.processingStack;
            stack.func_77978_p().func_82580_o("ItemInventory");
            stack.func_77978_p().func_82580_o("PotEnergy");
            if (this.field_145850_b.field_73012_v.nextFloat() < n / 289.0f) {
                ((ItemStoneTablet)stack.func_77973_b()).setCursed(stack);
            }
            this.containerItemStacks.set(1, (Object)stack);
            this.processingStack = ItemStack.field_190927_a;
        }
    }

    public String func_70005_c_() {
        return "container.abyssalcraft.energydepositioner";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.containerItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.containerItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.containerItemStacks.get(index);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return ItemStackHelper.func_188382_a(this.containerItemStacks, (int)var1, (int)var2);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.containerItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containerItemStacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemStoneTablet;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.processingTime;
            }
            case 1: {
                return (int)this.energy;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.processingTime = value;
                break;
            }
            case 1: {
                this.energy = value;
            }
        }
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else if (side == EnumFacing.UP) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return direction == EnumFacing.UP && index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction == EnumFacing.DOWN && index == 1;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == EnumFacing.DOWN || facing == EnumFacing.UP) || super.hasCapability(capability, facing);
    }
}

