/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.energy.IEnergyContainer;
import com.shinoow.abyssalcraft.api.energy.PEUtils;
import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityEnergyRelay;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileEntityTieredEnergyRelay
extends TileEntityEnergyRelay {
    private int facing;
    private int ticksExisted;

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.facing = nbttagcompound.func_74762_e("Facing");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("Facing", this.facing);
        return nbttagcompound;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        super.onDataPacket(net, packet);
    }

    @Override
    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.field_175730_i.remove(this);
        }
        this.ticksExisted = this.field_145850_b.field_73012_v.nextInt(100);
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return;
        }
        ++this.ticksExisted;
        if (this.ticksExisted % 20 == 0) {
            PEUtils.collectNearbyPE(this, this.field_145850_b, this.field_174879_c, EnumFacing.func_82600_a((int)this.facing).func_176734_d(), this.getDrainQuanta());
        }
        if (this.ticksExisted % 40 == 0 && this.canTransferPE()) {
            this.transferPE(EnumFacing.func_82600_a((int)this.facing), this.getTransferQuanta());
        }
    }

    @Override
    public void transferPE(EnumFacing facing, float energy) {
        IEnergyContainer container;
        if (PEUtils.canTransfer(this.field_145850_b, this.field_174879_c, facing, this.getRange()) && (container = PEUtils.getContainer(this.field_145850_b, this.field_174879_c, facing, this.getRange())) != null && container.canAcceptPE()) {
            container.addEnergy(this.consumeEnergy(energy));
            AbyssalCraftAPI.getInternalMethodHandler().spawnPEStream(this.field_174879_c, container.getContainerTile().func_174877_v(), this.field_145850_b.field_73011_w.getDimension());
        }
    }

    @Override
    public TileEntity getContainerTile() {
        return this;
    }

    protected int getRange() {
        switch (this.func_145832_p()) {
            case 0: {
                return 6;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 10;
            }
            case 3: {
                return 12;
            }
        }
        return 0;
    }

    protected float getDrainQuanta() {
        switch (this.func_145832_p()) {
            case 0: {
                return 15.0f;
            }
            case 1: {
                return 25.0f;
            }
            case 2: {
                return 35.0f;
            }
            case 3: {
                return 45.0f;
            }
        }
        return 0.0f;
    }

    protected float getTransferQuanta() {
        switch (this.func_145832_p()) {
            case 0: {
                return 20.0f;
            }
            case 1: {
                return 30.0f;
            }
            case 2: {
                return 40.0f;
            }
            case 3: {
                return 50.0f;
            }
        }
        return 0.0f;
    }

    public int getFacing() {
        return this.facing;
    }

    public void setFacing(int face) {
        this.facing = face;
    }
}

