/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.disruptions;

import com.shinoow.abyssalcraft.api.energy.disruption.DisruptionEntry;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DisruptionTeleportRandomly
extends DisruptionEntry {
    public DisruptionTeleportRandomly() {
        super("randomTeleport", null);
    }

    @Override
    public void disrupt(World world, BlockPos pos, List<EntityPlayer> players) {
        if (!players.isEmpty()) {
            for (EntityPlayer player : players) {
                this.teleportRandomly(player, world);
            }
        }
    }

    protected boolean teleportRandomly(EntityPlayer player, World world) {
        double d0 = player.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * 64.0;
        double d1 = player.field_70163_u + (double)(world.field_73012_v.nextInt(64) - 32);
        double d2 = player.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2, player, world);
    }

    protected boolean teleportTo(double par1, double par3, double par5, EntityPlayer player, World world) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)player, par1, par3, par5, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = player.field_70165_t;
        double d4 = player.field_70163_u;
        double d5 = player.field_70161_v;
        player.field_70165_t = event.getTargetX();
        player.field_70163_u = event.getTargetY();
        player.field_70161_v = event.getTargetZ();
        boolean flag = false;
        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        if (world.func_175667_e(pos)) {
            boolean flag1 = false;
            while (!flag1 && pos.func_177956_o() > 0) {
                BlockPos pos1 = pos.func_177977_b();
                IBlockState block = world.func_180495_p(pos1);
                if (block.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                player.field_70163_u -= 1.0;
                pos = pos1;
            }
            if (flag1) {
                player.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                if (world.func_184144_a((Entity)player, player.func_174813_aQ()).isEmpty() && !world.func_72953_d(player.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            player.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float f1 = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float f2 = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (player.field_70165_t - d3) * d6 + (world.field_73012_v.nextDouble() - 0.5) * (double)player.field_70130_N * 2.0;
            double d8 = d4 + (player.field_70163_u - d4) * d6 + world.field_73012_v.nextDouble() * (double)player.field_70131_O;
            double d9 = d5 + (player.field_70161_v - d5) * d6 + (world.field_73012_v.nextDouble() - 0.5) * (double)player.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
        }
        world.func_184134_a(d3, d4, d5, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        return true;
    }
}

