/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.handlers;

import com.shinoow.abyssalcraft.api.necronomicon.condition.caps.INecroDataCapability;
import com.shinoow.abyssalcraft.api.necronomicon.condition.caps.NecroDataCapability;
import com.shinoow.abyssalcraft.api.necronomicon.condition.caps.NecroDataCapabilityProvider;
import com.shinoow.abyssalcraft.common.network.PacketDispatcher;
import com.shinoow.abyssalcraft.common.network.client.KnowledgeUnlockMessage;
import com.shinoow.abyssalcraft.common.network.client.NecroDataCapMessage;
import com.shinoow.abyssalcraft.lib.ACConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class KnowledgeEventHandler {
    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("abyssalcraft", "necrodata"), (ICapabilityProvider)new NecroDataCapabilityProvider());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
            INecroDataCapability cap = NecroDataCapability.getCap((EntityPlayer)player);
            if (cap.getSyncTimer() < ACConfig.knowledgeSyncDelay) {
                cap.incrementSyncTimer();
            } else if (cap.getSyncTimer() == ACConfig.knowledgeSyncDelay) {
                cap.incrementSyncTimer();
                NecroDataCapability.getCap((EntityPlayer)player).setLastSyncTime(System.currentTimeMillis());
                PacketDispatcher.sendTo(new NecroDataCapMessage((EntityPlayer)player), player);
            }
            Biome b = player.field_70170_p.func_180494_b(player.func_180425_c());
            if (player.field_70173_aa % 200 == 0 && ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)b) != null) {
                String name = ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)b).toString();
                if (!cap.getBiomeTriggers().contains(name)) {
                    cap.triggerBiomeUnlock(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)b).toString());
                    PacketDispatcher.sendTo(new KnowledgeUnlockMessage(0, name), player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        INecroDataCapability cap = NecroDataCapability.getCap(event.player);
        if (!cap.getDimensionTriggers().contains(event.toDim)) {
            cap.triggerDimensionUnlock(event.toDim);
            PacketDispatcher.sendTo(new KnowledgeUnlockMessage(2, event.toDim), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer) && !event.getEntityLiving().field_70170_p.field_72995_K) {
            EntityLivingBase e = event.getEntityLiving();
            if (event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer && EntityList.func_191301_a((Entity)e) != null) {
                String name = EntityList.func_191301_a((Entity)e).toString();
                INecroDataCapability cap = NecroDataCapability.getCap((EntityPlayer)event.getSource().func_76346_g());
                if (!cap.getEntityTriggers().contains(name)) {
                    cap.triggerEntityUnlock(name);
                    PacketDispatcher.sendTo(new KnowledgeUnlockMessage(1, name), (EntityPlayerMP)event.getSource().func_76346_g());
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            NecroDataCapability.getCap((EntityPlayer)event.getEntity()).resetSyncTimer();
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        NecroDataCapability.getCap(event.getEntityPlayer()).copy(NecroDataCapability.getCap(event.getOriginal()));
    }
}

