/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.spells;

import com.google.common.collect.Sets;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.spell.Spell;
import com.shinoow.abyssalcraft.common.blocks.BlockACCobblestone;
import com.shinoow.abyssalcraft.common.blocks.BlockACStone;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class MiningSpell
extends Spell {
    public MiningSpell() {
        super("mining", 500.0f, Items.field_151039_o, Items.field_151050_s, Items.field_151035_b, Items.field_151005_D, Items.field_151046_w);
        this.setRequiresCharging();
        this.setColor(12868357);
    }

    @Override
    public boolean canCastSpell(World world, BlockPos pos, EntityPlayer player) {
        RayTraceResult r = this.rayTrace(player, world, 16.0, 1.0f);
        if (r != null && r.field_72313_a == RayTraceResult.Type.BLOCK) {
            for (BlockPos pos2 : this.getPositions(r.func_178782_a(), r.field_178784_b.func_176734_d())) {
                IBlockState state = this.getRemains(world.func_180495_p(pos2));
                if (state == null || !world.func_175660_a(player, pos2)) continue;
                return true;
            }
        }
        return false;
    }

    private IBlockState getRemains(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150348_b || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == ACBlocks.stone && state.func_177229_b(BlockACStone.TYPE) != BlockACStone.EnumStoneType.CORALIUM_STONE && state.func_177229_b(BlockACStone.TYPE) != BlockACStone.EnumStoneType.ETHAXIUM || state.func_177230_c() == Blocks.field_150351_n || state.func_177230_c() == Blocks.field_150322_A || state.func_177230_c() == ACBlocks.dreadlands_dirt) {
            return Blocks.field_150356_k.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(7));
        }
        if (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (state == ACBlocks.stone.func_176223_P().func_177226_a(BlockACStone.TYPE, (Comparable)((Object)BlockACStone.EnumStoneType.CORALIUM_STONE))) {
            return ACBlocks.liquid_coralium.func_176223_P();
        }
        return null;
    }

    private IBlockState getResult(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150347_e) {
            return Blocks.field_150348_b.func_176223_P();
        }
        if (state.func_177230_c() == ACBlocks.cobblestone) {
            return ACBlocks.stone.func_176223_P().func_177226_a(BlockACStone.TYPE, (Comparable)((Object)BlockACStone.EnumStoneType.byMetadata(((BlockACCobblestone.EnumCobblestoneType)((Object)state.func_177229_b(BlockACCobblestone.TYPE))).getMeta())));
        }
        if (state.func_177230_c() == Blocks.field_150354_m && state.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.SAND) {
            return Blocks.field_150359_w.func_176223_P();
        }
        if (state.func_177230_c() == Blocks.field_150354_m && state.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND) {
            return Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.RED);
        }
        if (state.func_177230_c() == ACBlocks.abyssal_sand) {
            return ACBlocks.abyssal_sand_glass.func_176223_P();
        }
        return null;
    }

    public RayTraceResult rayTrace(EntityPlayer player, World world, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = player.func_174824_e(partialTicks);
        Vec3d vec3d1 = player.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return world.func_147447_a(vec3d, vec3d2, true, false, true);
    }

    private Set<BlockPos> getPositions(BlockPos pos, EnumFacing facing) {
        HashSet stuff = Sets.newHashSetWithExpectedSize((int)9);
        EnumFacing.Axis a = facing.func_176740_k();
        if (a.func_176722_c()) {
            for (int i = 1; i > -2; --i) {
                for (int j = 1; j > -2; --j) {
                    stuff.add(pos.func_177982_a(a == EnumFacing.Axis.Z ? i : 0, j, a == EnumFacing.Axis.X ? i : 0));
                }
            }
        } else {
            for (int i = 1; i > -2; --i) {
                for (int j = 1; j > -2; --j) {
                    stuff.add(pos.func_177982_a(i, 0, j));
                }
            }
        }
        return stuff;
    }

    private Set<BlockPos> getOuterPositions(BlockPos pos, EnumFacing facing) {
        HashSet stuff = Sets.newHashSet();
        EnumFacing.Axis a = facing.func_176740_k();
        if (a.func_176722_c()) {
            for (int i = 2; i > -3; --i) {
                for (int j = 2; j > -3; --j) {
                    stuff.add(pos.func_177982_a(a == EnumFacing.Axis.Z ? i : 0, j, a == EnumFacing.Axis.X ? i : 0));
                }
            }
        } else {
            for (int i = 2; i > -3; --i) {
                for (int j = 2; j > -3; --j) {
                    stuff.add(pos.func_177982_a(i, 0, j));
                }
            }
        }
        stuff.removeAll(this.getPositions(pos, facing));
        return stuff;
    }

    @Override
    protected void castSpellClient(World world, BlockPos pos, EntityPlayer player) {
    }

    @Override
    protected void castSpellServer(World world, BlockPos pos, EntityPlayer player) {
        RayTraceResult r = this.rayTrace(player, world, 16.0, 1.0f);
        float f = 0.0f;
        if (r != null && r.field_72313_a == RayTraceResult.Type.BLOCK) {
            int i = 0;
            while (f < 500.0f && !(f >= 500.0f)) {
                IBlockState state;
                for (BlockPos pos2 : this.getPositions(r.func_178782_a().func_177967_a(r.field_178784_b.func_176734_d(), i), r.field_178784_b.func_176734_d())) {
                    state = this.getRemains(world.func_180495_p(pos2));
                    if (state == null || !world.func_175660_a(player, pos2)) continue;
                    f = (float)((double)f + (double)world.func_180495_p(pos2).func_185887_b(world, pos2) * (world.func_180495_p(pos2).func_185904_a().func_76224_d() ? 0.5 : 2.0));
                    if (i == 0) {
                        world.func_175655_b(pos2, false);
                    }
                    world.func_175656_a(pos2, state);
                    if (!(f >= 500.0f)) continue;
                    break;
                }
                for (BlockPos pos2 : this.getOuterPositions(r.func_178782_a().func_177967_a(r.field_178784_b.func_176734_d(), i), r.field_178784_b.func_176734_d())) {
                    state = this.getResult(world.func_180495_p(pos2));
                    if (state == null || !world.func_175660_a(player, pos2)) continue;
                    f = (float)((double)f + (double)world.func_180495_p(pos2).func_185887_b(world, pos2) * (world.func_180495_p(pos2).func_185904_a().func_76224_d() ? 0.5 : 2.0));
                    if (i == 0) {
                        world.func_175655_b(pos2, false);
                    }
                    world.func_175656_a(pos2, state);
                    if (!(f >= 500.0f)) continue;
                    break;
                }
                if (i >= 128) break;
                ++i;
            }
        }
    }
}

