/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.world.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class NecromancyWorldSavedData
extends WorldSavedData {
    private static final String DATA_NAME = "abyssalcraft_necromancy_data";
    List<Tuple<String, NBTTagCompound>> data = new ArrayList<Tuple<String, NBTTagCompound>>();
    Map<String, Integer> sizes = new HashMap<String, Integer>();

    public NecromancyWorldSavedData() {
        super(DATA_NAME);
    }

    public NecromancyWorldSavedData(String s) {
        super(s);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagCompound properties = nbt;
        NBTTagCompound data = properties.func_74775_l("Data");
        NBTTagCompound sizes = properties.func_74775_l("Sizes");
        for (String name : data.func_150296_c()) {
            this.storeData(name, data.func_74775_l(name), sizes.func_74762_e(name));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        NBTTagCompound sizes = new NBTTagCompound();
        for (Map.Entry<String, Integer> e : this.getSizeData().entrySet()) {
            sizes.func_74768_a(e.getKey(), e.getValue().intValue());
        }
        properties.func_74782_a("Sizes", (NBTBase)sizes);
        NBTTagCompound data = new NBTTagCompound();
        for (Tuple<String, NBTTagCompound> t : this.getData()) {
            data.func_74782_a((String)t.func_76341_a(), (NBTBase)t.func_76340_b());
        }
        properties.func_74782_a("Data", (NBTBase)data);
        return properties;
    }

    public NBTTagCompound getDataForName(String name) {
        for (Tuple<String, NBTTagCompound> t : this.data) {
            if (!((String)t.func_76341_a()).equals(name)) continue;
            return (NBTTagCompound)t.func_76340_b();
        }
        return null;
    }

    public int getSizeForName(String name) {
        return this.sizes.getOrDefault(name, 0);
    }

    public void storeData(String name, NBTTagCompound data, int size) {
        if (this.getDataForName(name) == null) {
            if (this.data.size() == 5) {
                this.sizes.remove(this.data.get(0).func_76341_a());
                this.data.remove(0);
            }
            this.data.add((Tuple<String, NBTTagCompound>)new Tuple((Object)name, (Object)data));
        } else {
            for (Tuple<String, NBTTagCompound> tuple : this.data) {
                if (!((String)tuple.func_76341_a()).equals(name)) continue;
                Tuple tuple2 = new Tuple((Object)name, (Object)data);
                break;
            }
        }
        this.sizes.put(name, size);
        this.func_76185_a();
    }

    public void clearEntry(String name) {
        for (Tuple<String, NBTTagCompound> t : this.data) {
            if (!((String)t.func_76341_a()).equals(name)) continue;
            this.data.remove(t);
            break;
        }
        this.sizes.remove(name);
        this.func_76185_a();
    }

    public List<Tuple<String, NBTTagCompound>> getData() {
        return this.data;
    }

    public Map<String, Integer> getSizeData() {
        return this.sizes;
    }

    public static NecromancyWorldSavedData get(World world) {
        MapStorage storage = world.func_175693_T();
        NecromancyWorldSavedData instance = (NecromancyWorldSavedData)storage.func_75742_a(NecromancyWorldSavedData.class, DATA_NAME);
        if (instance == null) {
            instance = new NecromancyWorldSavedData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }
}

