/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.plugins.PluginTEBase;
import cofh.thermalexpansion.util.managers.device.TapperManager;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PluginTConstruct
extends PluginTEBase {
    public static final String MOD_ID = "tconstruct";
    public static final String MOD_NAME = "Tinkers' Construct";

    public PluginTConstruct() {
        super(MOD_ID, MOD_NAME);
    }

    @Override
    public void initializeDelegate() {
        ItemStack slimeCongealed = this.getItemStack("slime_congealed", 1, 0);
        ItemStack slimeCongealedMagma = this.getItemStack("slime_congealed", 1, 4);
        ItemStack saplingSlimeBlue = this.getItemStack("slime_sapling", 1, 0);
        ItemStack saplingSlimePurple = this.getItemStack("slime_sapling", 1, 1);
        ItemStack saplingSlimeMagma = this.getItemStack("slime_sapling", 1, 2);
        Block log = this.getBlock("slime_congealed");
        Block leaves = this.getBlock("slime_leaves");
        Fluid blueslime = FluidRegistry.getFluid((String)"blueslime");
        Fluid emerald = FluidRegistry.getFluid((String)"emerald");
        this.addRecipeSet("iron");
        this.addRecipeSet("gold");
        if (emerald != null) {
            CrucibleManager.addRecipe(4000, new ItemStack(Items.field_151166_bC), new FluidStack(emerald, 666));
            CrucibleManager.addRecipe(8000, new ItemStack(Blocks.field_150412_bA), new FluidStack(emerald, 1332));
            CrucibleManager.addRecipe(32000, new ItemStack(Blocks.field_150475_bE), new FluidStack(emerald, 5994));
        }
        this.addRecipeSet("copper");
        this.addRecipeSet("tin");
        this.addRecipeSet("silver");
        this.addRecipeSet("lead");
        this.addRecipeSet("aluminum");
        this.addRecipeSet("nickel");
        this.addRecipeSet("platinum");
        this.addRecipeSet("iridium");
        this.addRecipeSet("steel");
        this.addRecipeSet("electrum");
        this.addRecipeSet("invar");
        this.addRecipeSet("bronze");
        this.addRecipeSet("constantan");
        this.addRecipeSet("signalum");
        this.addRecipeSet("lumium");
        this.addRecipeSet("enderium");
        this.addRecipeSet("ardite");
        this.addRecipeSet("cobalt");
        this.addRecipeSet("manyullyn");
        InsolatorManager.addDefaultTreeRecipe(saplingSlimeBlue, ItemHelper.cloneStack((ItemStack)slimeCongealed, (int)6), saplingSlimeBlue);
        InsolatorManager.addDefaultTreeRecipe(saplingSlimePurple, ItemHelper.cloneStack((ItemStack)slimeCongealed, (int)6), saplingSlimePurple);
        InsolatorManager.addDefaultTreeRecipe(saplingSlimeMagma, ItemHelper.cloneStack((ItemStack)slimeCongealedMagma, (int)6), saplingSlimeMagma);
        TapperManager.addStandardMapping(slimeCongealed, new FluidStack(blueslime, 25));
        TapperManager.addStandardMapping(slimeCongealedMagma, new FluidStack(blueslime, 25));
        this.addLeafMapping(log, 0, leaves, 0);
        this.addLeafMapping(log, 0, leaves, 1);
        this.addLeafMapping(log, 4, leaves, 2);
    }

    protected boolean addRecipeSet(String oreType) {
        if (oreType == null || oreType.isEmpty()) {
            return false;
        }
        Fluid fluid = FluidRegistry.getFluid((String)oreType.toLowerCase(Locale.ENGLISH));
        if (fluid == null) {
            return false;
        }
        oreType = StringHelper.titleCase((String)oreType);
        int energy = 4000;
        int fluidIngot = 144;
        String nuggetName = "nugget" + oreType;
        String ingotName = "ingot" + oreType;
        String oreName = "ore" + oreType;
        String blockName = "block" + oreType;
        String dustName = "dust" + oreType;
        String plateName = "plate" + oreType;
        ItemStack nugget = ItemHelper.getOre((String)nuggetName);
        ItemStack ingot = ItemHelper.getOre((String)ingotName);
        ItemStack ore = ItemHelper.getOre((String)oreName);
        ItemStack block = ItemHelper.getOre((String)blockName);
        ItemStack dust = ItemHelper.getOre((String)dustName);
        ItemStack plate = ItemHelper.getOre((String)plateName);
        if (!nugget.func_190926_b()) {
            CrucibleManager.addRecipe(energy / 8, nugget, new FluidStack(fluid, fluidIngot / 9));
        }
        if (!ingot.func_190926_b()) {
            CrucibleManager.addRecipe(energy, ingot, new FluidStack(fluid, fluidIngot));
        }
        if (!ore.func_190926_b()) {
            CrucibleManager.addRecipe(energy * 2, ore, new FluidStack(fluid, fluidIngot * 2));
        }
        if (!block.func_190926_b()) {
            CrucibleManager.addRecipe(energy * 8, block, new FluidStack(fluid, fluidIngot * 9));
        }
        if (!dust.func_190926_b()) {
            CrucibleManager.addRecipe(energy / 2, dust, new FluidStack(fluid, fluidIngot));
        }
        if (!plate.func_190926_b()) {
            CrucibleManager.addRecipe(energy, plate, new FluidStack(fluid, fluidIngot));
        }
        return true;
    }
}

