/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.furnace;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiFurnace;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.furnace.FurnaceRecipeCategoryFood;
import cofh.thermalexpansion.plugins.jei.machine.furnace.FurnaceRecipeCategoryOre;
import cofh.thermalexpansion.plugins.jei.machine.furnace.FurnaceRecipeCategoryPyrolysis;
import cofh.thermalexpansion.plugins.jei.machine.furnace.FurnaceRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class FurnaceRecipeCategory
extends BaseRecipeCategory<FurnaceRecipeWrapper> {
    public static boolean enable = true;
    protected IDrawableStatic progress;
    protected IDrawableStatic speed;

    public static void register(IRecipeCategoryRegistration registry) {
        String category = "Plugins.JEI";
        if (!(enable = ThermalExpansion.CONFIG_CLIENT.get(category, "Machine.Furnace", enable))) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new FurnaceRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FurnaceRecipeCategoryFood(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FurnaceRecipeCategoryOre(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FurnaceRecipeCategoryPyrolysis(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(FurnaceRecipeCategory.getRecipes(guiHelper), "thermalexpansion.furnace");
        registry.addRecipeClickArea(GuiFurnace.class, 79, 34, 24, 16, new String[]{"thermalexpansion.furnace", "thermalexpansion.furnace_food", "thermalexpansion.furnace_ore", "thermalexpansion.furnace_pyrolysis"});
        registry.addRecipeCatalyst((Object)BlockMachine.machineFurnace, new String[]{"thermalexpansion.furnace"});
        FurnaceRecipeCategoryFood.initialize(registry);
        FurnaceRecipeCategoryOre.initialize(registry);
        FurnaceRecipeCategoryPyrolysis.initialize(registry);
    }

    public static List<FurnaceRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<FurnaceRecipeWrapper> recipes = new ArrayList<FurnaceRecipeWrapper>();
        for (FurnaceManager.FurnaceRecipe recipe : FurnaceManager.getRecipeList(false)) {
            recipes.add(new FurnaceRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public FurnaceRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiFurnace.TEXTURE, 26, 11, 124, 62, 0, 0, 16, 24);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.furnace.name");
        this.progress = Drawables.getDrawables(guiHelper).getProgress(0);
        this.speed = Drawables.getDrawables(guiHelper).getScale(4);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.furnace";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 43, 33);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, FurnaceRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 42, 14);
        guiItemStacks.init(1, false, 105, 23);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (List)outputs.get(0));
    }
}

