/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers.dynamo;

import cofh.thermalexpansion.util.managers.dynamo.ReactantManager;
import cofh.thermalexpansion.util.parsers.BaseParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;

public class ReactantParser
extends BaseParser {
    public static final String ELEMENTAL = "elemental";
    int defaultEnergy = ReactantManager.DEFAULT_ENERGY;

    @Override
    public void parseArray(JsonArray contentArray) {
        for (JsonElement contentElement : contentArray) {
            JsonObject content = contentElement.getAsJsonObject();
            if (content.has("//")) continue;
            int energy = this.defaultEnergy;
            ItemStack input = ReactantParser.parseItemStack(content.get("input"));
            String fluidName = content.get("fluid").getAsString();
            if (content.has("energy")) {
                energy = content.get("energy").getAsInt();
            } else if (content.has("energy_mod")) {
                energy = content.get("energy_mod").getAsInt() * this.defaultEnergy / 100;
            }
            if (content.has("type")) {
                if (ELEMENTAL.equals(content.get("type").getAsString())) {
                    if (ReactantManager.addElementalReaction(input, FluidRegistry.getFluid((String)fluidName), energy)) {
                        ++this.parseCount;
                        continue;
                    }
                    ++this.errorCount;
                    continue;
                }
                ++this.errorCount;
                continue;
            }
            if (ReactantManager.addReaction(input, FluidRegistry.getFluid((String)fluidName), energy)) {
                ++this.parseCount;
                continue;
            }
            ++this.errorCount;
        }
    }
}

