/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch.client;

import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.client.WindowIconHandler;
import com.therandomlabs.randompatches.config.RPConfig;
import com.therandomlabs.randompatches.core.Patch;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.ScreenChatOptions;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.lwjgl.input.Keyboard;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public final class MinecraftPatch
extends Patch {
    public static final int KEY_UNUSED = 84;

    @Override
    public boolean apply(ClassNode node) {
        if (!RandomPatches.DEFAULT_WINDOW_TITLE.equals(RPConfig.Window.title)) {
            MinecraftPatch.patchCreateDisplay(MinecraftPatch.findInstructions(node, "createDisplay", "func_175609_am"));
        }
        if (!RPConfig.Window.icon16String.isEmpty()) {
            MinecraftPatch.patchSetWindowIcon(MinecraftPatch.findInstructions(node, "setWindowIcon", "func_175594_ao"));
        }
        if (RPConfig.Client.isNarratorKeybindEnabled()) {
            MinecraftPatch.patchDispatchKeypresses(MinecraftPatch.findInstructions(node, "dispatchKeypresses", "func_152348_aa"));
        }
        return true;
    }

    public static void handleKeypress() {
        int key;
        if (ToggleNarratorKeybind.keybind == null) {
            return;
        }
        int eventKey = Keyboard.getEventKey();
        int n = key = eventKey == 0 ? Keyboard.getEventCharacter() + 256 : eventKey;
        if (!ToggleNarratorKeybind.keybind.isActiveAndMatches(key)) {
            return;
        }
        Minecraft mc = ToggleNarratorKeybind.mc;
        mc.field_71474_y.func_74306_a(GameSettings.Options.NARRATOR, 1);
        if (mc.field_71462_r instanceof ScreenChatOptions) {
            ((ScreenChatOptions)mc.field_71462_r).func_193024_a();
        }
    }

    private static void patchCreateDisplay(InsnList instructions) {
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 184) continue;
            MethodInsnNode setTitle = (MethodInsnNode)instruction;
            if (!"setTitle".equals(setTitle.name)) continue;
            ((LdcInsnNode)setTitle.getPrevious()).cst = RPConfig.Window.title;
            return;
        }
    }

    private static void patchSetWindowIcon(InsnList instructions) {
        InsnList newInstructions = new InsnList();
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, MinecraftPatch.getName(WindowIconHandler.class), "setWindowIcon", "()V", false));
        newInstructions.add((AbstractInsnNode)new InsnNode(177));
        instructions.insertBefore(instructions.getFirst(), newInstructions);
    }

    private static void patchDispatchKeypresses(InsnList instructions) {
        IntInsnNode isB = null;
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 16) continue;
            isB = (IntInsnNode)instruction;
            if (isB.operand == 48) break;
            isB = null;
        }
        instructions.insertBefore(isB.getPrevious(), (AbstractInsnNode)new MethodInsnNode(184, MinecraftPatch.getName(MinecraftPatch.class), "handleKeypress", "()V", false));
        isB.operand = 84;
    }

    public static final class ToggleNarratorKeybind {
        public static final Minecraft mc = Minecraft.func_71410_x();
        public static KeyBinding keybind;

        private ToggleNarratorKeybind() {
        }

        public static void register() {
            keybind = new KeyBinding("key.narrator", new IKeyConflictContext(){

                public boolean isActive() {
                    return !(ToggleNarratorKeybind.mc.field_71462_r instanceof GuiControls);
                }

                public boolean conflicts(IKeyConflictContext other) {
                    return true;
                }
            }, KeyModifier.CONTROL, 48, "key.categories.misc");
            ClientRegistry.registerKeyBinding((KeyBinding)keybind);
        }
    }
}

