/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block;

import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectMovement;
import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffectUpdraft;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.tile.TileAlchemyArray;
import WayofTime.bloodmagic.util.Utils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAlchemyArray
extends Block {
    protected static final AxisAlignedBB ARRAY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1, 1.0);

    public BlockAlchemyArray() {
        super(Material.field_151580_n);
        this.func_149663_c("bloodmagic.alchemyArray");
        this.func_149711_c(0.1f);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAlchemyArray) {
            ((TileAlchemyArray)tile).onEntityCollidedWithBlock(state, entity);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ARRAY_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileAlchemyArray array = (TileAlchemyArray)world.func_175625_s(pos);
        if (array == null) {
            return false;
        }
        if (player.func_70093_af() && array.rotateCooldown == 0) {
            array.setRotation(array.getRotation().func_176746_e());
            array.rotateCooldown = 5;
            world.func_184138_a(pos, state, state, 3);
            return false;
        }
        ItemStack playerItem = player.func_184586_b(hand);
        if (!playerItem.func_190926_b()) {
            if (array.func_70301_a(0).func_190926_b()) {
                Utils.insertItemToTile(array, player, 0);
            } else if (!array.func_70301_a(0).func_190926_b()) {
                Utils.insertItemToTile(array, player, 1);
                array.attemptCraft();
            } else {
                return true;
            }
            if (array.arrayEffect instanceof AlchemyArrayEffectMovement && (playerItem.func_77973_b() == Items.field_151137_ax || playerItem.func_77973_b() == Items.field_151008_G) || array.arrayEffect instanceof AlchemyArrayEffectUpdraft && (playerItem.func_77973_b() == Items.field_151008_G || playerItem.func_77973_b() == Items.field_151114_aO)) {
                for (int i = 0; i < array.func_70302_i_(); ++i) {
                    ItemStack stack = array.func_70301_a(i);
                    if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)playerItem)) continue;
                    if (stack.func_190916_E() >= 127) break;
                    stack.func_190920_e(stack.func_190916_E() + 1);
                    playerItem.func_190918_g(1);
                    break;
                }
                world.func_184138_a(pos, state, state, 3);
                return true;
            }
        }
        world.func_184138_a(pos, state, state, 3);
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(RegistrarBloodMagicItems.ARCANE_ASHES);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180663_b(World world, BlockPos blockPos, IBlockState blockState) {
        TileAlchemyArray alchemyArray = (TileAlchemyArray)world.func_175625_s(blockPos);
        if (alchemyArray != null) {
            alchemyArray.dropItems();
        }
        super.func_180663_b(world, blockPos, blockState);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAlchemyArray();
    }
}

