/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.core.registry;

import WayofTime.bloodmagic.altar.AltarTier;
import WayofTime.bloodmagic.util.BMLog;
import WayofTime.bloodmagic.util.ItemStackWrapper;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class AltarRecipeRegistry {
    private static BiMap<List<ItemStackWrapper>, AltarRecipe> recipes = HashBiMap.create();

    public static void registerRecipe(AltarRecipe altarRecipe) {
        if (!recipes.containsValue((Object)altarRecipe) && altarRecipe.getInput().size() > 0) {
            recipes.put(altarRecipe.getInput(), (Object)altarRecipe);
        } else {
            BMLog.DEFAULT.error("Error adding altar recipe for input [{}].", altarRecipe.toString());
        }
    }

    public static void registerFillRecipe(ItemStack orbStack, AltarTier tier, int maxForOrb, int consumeRate, int drainRate) {
        AltarRecipeRegistry.registerRecipe(new AltarRecipe(orbStack, orbStack, tier, maxForOrb, consumeRate, drainRate, true));
    }

    public static void removeRecipe(AltarRecipe altarRecipe) {
        recipes.remove(altarRecipe.getInput());
    }

    public static AltarRecipe getRecipeForInput(List<ItemStack> input) {
        List<ItemStackWrapper> wrapperList = ItemStackWrapper.toWrapperList(input);
        if (recipes.keySet().contains(wrapperList)) {
            return (AltarRecipe)recipes.get(wrapperList);
        }
        return null;
    }

    public static AltarRecipe getRecipeForInput(ItemStack input) {
        for (AltarRecipe recipe : recipes.values()) {
            if (!recipe.doesRequiredItemMatch(input, recipe.getMinTier())) continue;
            return recipe;
        }
        return null;
    }

    public static AltarRecipe getRecipeForInput(String input) {
        return AltarRecipeRegistry.getRecipeForInput((List<ItemStack>)OreDictionary.getOres((String)input));
    }

    public static BiMap<List<ItemStackWrapper>, AltarRecipe> getRecipes() {
        return HashBiMap.create(recipes);
    }

    public static class AltarRecipe {
        private final List<ItemStackWrapper> input;
        private final ItemStack output;
        private final AltarTier minTier;
        private final int syphon;
        private final int consumeRate;
        private final int drainRate;
        private final boolean fillable;

        public AltarRecipe(List<ItemStack> input, ItemStack output, AltarTier minTier, int syphon, int consumeRate, int drainRate, boolean fillable) {
            this.input = ItemStackWrapper.toWrapperList(input);
            this.output = output;
            this.minTier = minTier;
            this.syphon = syphon < 0 ? -syphon : syphon;
            this.consumeRate = consumeRate < 0 ? -consumeRate : consumeRate;
            this.drainRate = drainRate < 0 ? -drainRate : drainRate;
            this.fillable = fillable;
        }

        public AltarRecipe(List<ItemStack> input, ItemStack output, AltarTier minTier, int syphon, int consumeRate, int drainRate) {
            this(input, output, minTier, syphon, consumeRate, drainRate, false);
        }

        public AltarRecipe(ItemStack input, ItemStack output, AltarTier minTier, int syphon, int consumeRate, int drainRate, boolean fillable) {
            this(Collections.singletonList(input), output, minTier, syphon, consumeRate, drainRate, fillable);
        }

        public AltarRecipe(ItemStack input, ItemStack output, AltarTier minTier, int syphon, int consumeRate, int drainRate) {
            this(Collections.singletonList(input), output, minTier, syphon, consumeRate, drainRate, false);
        }

        public AltarRecipe(String inputEntry, ItemStack output, AltarTier minTier, int syphon, int consumeRate, int drainRate, boolean fillable) {
            this((List<ItemStack>)(OreDictionary.doesOreNameExist((String)inputEntry) && OreDictionary.getOres((String)inputEntry).size() > 0 ? OreDictionary.getOres((String)inputEntry) : Collections.emptyList()), output, minTier, syphon, consumeRate, drainRate, fillable);
        }

        public AltarRecipe(String inputEntry, ItemStack output, AltarTier minTier, int syphon, int consumeRate, int drainRate) {
            this((List<ItemStack>)(OreDictionary.doesOreNameExist((String)inputEntry) && OreDictionary.getOres((String)inputEntry).size() > 0 ? OreDictionary.getOres((String)inputEntry) : Collections.emptyList()), output, minTier, syphon, consumeRate, drainRate, false);
        }

        public boolean doesRequiredItemMatch(ItemStack comparedStack, AltarTier tierCheck) {
            if (comparedStack == null || this.input == null) {
                return false;
            }
            if (tierCheck.ordinal() < this.minTier.ordinal()) {
                return false;
            }
            for (ItemStackWrapper stack : this.input) {
                if (comparedStack.func_77969_a(stack.toStack())) {
                    return true;
                }
                if (comparedStack.func_77973_b() != stack.item || stack.meta != Short.MAX_VALUE) continue;
                return true;
            }
            return false;
        }

        public List<ItemStackWrapper> getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public AltarTier getMinTier() {
            return this.minTier;
        }

        public int getSyphon() {
            return this.syphon;
        }

        public int getConsumeRate() {
            return this.consumeRate;
        }

        public int getDrainRate() {
            return this.drainRate;
        }

        public boolean isFillable() {
            return this.fillable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AltarRecipe)) {
                return false;
            }
            AltarRecipe that = (AltarRecipe)o;
            if (this.syphon != that.syphon) {
                return false;
            }
            if (this.consumeRate != that.consumeRate) {
                return false;
            }
            if (this.drainRate != that.drainRate) {
                return false;
            }
            if (this.fillable != that.fillable) {
                return false;
            }
            if (this.input != null ? !this.input.equals(that.input) : that.input != null) {
                return false;
            }
            if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
                return false;
            }
            return this.minTier == that.minTier;
        }

        public int hashCode() {
            int result = this.input != null ? this.input.hashCode() : 0;
            result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
            result = 31 * result + (this.minTier != null ? this.minTier.hashCode() : 0);
            result = 31 * result + this.syphon;
            result = 31 * result + this.consumeRate;
            result = 31 * result + this.drainRate;
            result = 31 * result + (this.fillable ? 1 : 0);
            return result;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("input", this.input).append("output", (Object)this.output).append("minTier", (Object)this.minTier).append("syphon", this.syphon).append("consumeRate", this.consumeRate).append("drainRate", this.drainRate).append("fillable", this.fillable).toString();
        }
    }
}

