/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.entity.mob;

import WayofTime.bloodmagic.entity.mob.EntityDemonBase;
import WayofTime.bloodmagic.gson.Serializers;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import com.google.common.base.Predicate;
import java.util.Locale;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class EntityAspectedDemonBase
extends EntityDemonBase {
    protected static final DataParameter<EnumDemonWillType> TYPE = EntityDataManager.func_187226_a(EntityAspectedDemonBase.class, Serializers.WILL_TYPE_SERIALIZER);

    public EntityAspectedDemonBase(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)EnumDemonWillType.DEFAULT);
    }

    public double getMeleeResist() {
        return 0.0;
    }

    public double getProjectileResist() {
        return 0.0;
    }

    public double getMagicResist() {
        return 0.0;
    }

    public double getBaseHP(EnumDemonWillType type) {
        double baseHP = 40.0;
        switch (type) {
            case DEFAULT: {
                break;
            }
            case CORROSIVE: {
                break;
            }
            case DESTRUCTIVE: {
                break;
            }
            case VENGEFUL: {
                baseHP *= 0.8;
                break;
            }
            case STEADFAST: {
                baseHP *= 1.25;
            }
        }
        return baseHP;
    }

    public double getBaseMeleeDamage(EnumDemonWillType type) {
        double baseDamage = 8.0;
        switch (type) {
            case DEFAULT: {
                break;
            }
            case CORROSIVE: {
                baseDamage *= 0.8;
                break;
            }
            case DESTRUCTIVE: {
                baseDamage *= 1.5;
                break;
            }
            case VENGEFUL: {
                baseDamage *= 0.8;
                break;
            }
            case STEADFAST: {
                baseDamage *= 0.6;
            }
        }
        return baseDamage;
    }

    public double getBaseSpeed(EnumDemonWillType type) {
        double baseSpeed = 0.27;
        switch (type) {
            case DEFAULT: {
                break;
            }
            case CORROSIVE: {
                break;
            }
            case DESTRUCTIVE: {
                break;
            }
            case VENGEFUL: {
                baseSpeed *= 1.3;
                break;
            }
        }
        return baseSpeed;
    }

    public double getBaseSprintModifier(EnumDemonWillType type) {
        double baseSprint = 1.0;
        switch (type) {
            case DEFAULT: {
                break;
            }
            case CORROSIVE: {
                break;
            }
            case DESTRUCTIVE: {
                break;
            }
            case VENGEFUL: {
                baseSprint *= 1.2;
                break;
            }
        }
        return baseSprint;
    }

    public double getBaseKnockbackResist(EnumDemonWillType type) {
        double baseKnockback = 0.0;
        switch (type) {
            case DEFAULT: {
                break;
            }
            case CORROSIVE: {
                break;
            }
            case DESTRUCTIVE: {
                break;
            }
            case VENGEFUL: {
                break;
            }
            case STEADFAST: {
                baseKnockback += 0.35;
            }
        }
        return baseKnockback;
    }

    public void applyEntityAttributes(EnumDemonWillType type) {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseHP(type));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseSpeed(type));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getBaseMeleeDamage(type));
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.getBaseKnockbackResist(type));
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        float newAmount = amount;
        newAmount = source.func_76352_a() ? (float)((double)newAmount * MathHelper.func_151237_a((double)(1.0 - this.getProjectileResist()), (double)0.0, (double)1.0)) : (float)((double)newAmount * MathHelper.func_151237_a((double)(1.0 - this.getMeleeResist()), (double)0.0, (double)1.0));
        if (source.func_82725_o()) {
            newAmount = (float)((double)newAmount * MathHelper.func_151237_a((double)(1.0 - this.getMagicResist()), (double)0.0, (double)1.0));
        }
        return super.func_70097_a(source, newAmount);
    }

    public EnumDemonWillType getType() {
        return (EnumDemonWillType)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setType(EnumDemonWillType type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
        this.applyEntityAttributes(type);
        this.setCombatTask();
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74778_a("demonWillType", this.getType().toString());
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (!tag.func_74764_b("demonWillType")) {
            this.setType(EnumDemonWillType.DEFAULT);
        } else {
            this.setType(EnumDemonWillType.valueOf(tag.func_74779_i("demonWillType").toUpperCase(Locale.ENGLISH)));
        }
    }

    public class TeamAttackPredicate
    implements Predicate<EntityLivingBase> {
        private final EntityAspectedDemonBase demon;

        public TeamAttackPredicate(EntityAspectedDemonBase demon) {
            this.demon = demon;
        }

        public boolean apply(EntityLivingBase input) {
            if (input instanceof EntityAspectedDemonBase && ((EntityAspectedDemonBase)input).getType() == this.demon.getType()) {
                return false;
            }
            return input != null;
        }
    }

    public static class WillTypePredicate
    implements Predicate<EntityLivingBase> {
        private final EnumDemonWillType type;

        public WillTypePredicate(EnumDemonWillType type) {
            this.type = type;
        }

        public boolean apply(EntityLivingBase input) {
            return input instanceof EntityAspectedDemonBase && ((EntityAspectedDemonBase)input).getType() == this.type;
        }
    }
}

