/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.downgrade;

import WayofTime.bloodmagic.livingArmour.ILivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class LivingArmourUpgradeBattleHungry
extends LivingArmourUpgrade {
    public static final int[] costs = new int[]{-10, -20, -35, -50, -75};
    public static final float[] exhaustionAdded = new float[]{0.02f, 0.04f, 0.06f, 0.08f, 0.1f};
    public static final int[] delay = new int[]{600, 600, 600, 500, 400};
    public int timer = 0;

    public LivingArmourUpgradeBattleHungry(int level) {
        super(level);
    }

    public void resetTimer() {
        this.timer = delay[this.level];
    }

    @Override
    public void onTick(World world, EntityPlayer player, ILivingArmour livingArmour) {
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        if (player.field_70173_aa % 20 == 0) {
            player.func_71020_j(exhaustionAdded[this.level]);
        }
    }

    @Override
    public String getUniqueIdentifier() {
        return "bloodmagic.upgrade.battleHunger";
    }

    @Override
    public int getMaxTier() {
        return 5;
    }

    @Override
    public int getCostOfUpgrade() {
        return costs[this.level];
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("timer", this.timer);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.timer = tag.func_74762_e("timer");
    }

    @Override
    public String getTranslationKey() {
        return tooltipBase + "battleHunger";
    }

    @Override
    public boolean isDowngrade() {
        return true;
    }
}

