/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.network;

import WayofTime.bloodmagic.tile.routing.TileFilteredRoutingNode;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ItemRouterAmountPacketProcessor
implements IMessage,
IMessageHandler<ItemRouterAmountPacketProcessor, IMessage> {
    private int ghostItemSlot;
    private int amount;
    private int dimension;
    private BlockPos pos;

    public ItemRouterAmountPacketProcessor() {
    }

    public ItemRouterAmountPacketProcessor(int ghostItemSlot, int amount, BlockPos pos, World world) {
        this.ghostItemSlot = ghostItemSlot;
        this.amount = amount;
        this.pos = pos;
        this.dimension = world.field_73011_w.getDimension();
    }

    public void fromBytes(ByteBuf buffer) {
        PacketBuffer buff = new PacketBuffer(buffer);
        this.dimension = buff.readInt();
        this.pos = buff.func_179259_c();
        this.ghostItemSlot = buff.readInt();
        this.amount = buff.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        PacketBuffer buff = new PacketBuffer(buffer);
        buff.writeInt(this.dimension);
        buff.func_179255_a(this.pos);
        buff.writeInt(this.ghostItemSlot);
        buff.writeInt(this.amount);
    }

    public IMessage onMessage(ItemRouterAmountPacketProcessor message, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            message.onMessageFromClient();
        }
        return null;
    }

    public void onMessageFromClient() {
        WorldServer world = DimensionManager.getWorld((int)this.dimension);
        if (world != null) {
            if (!world.func_175667_e(this.pos)) {
                return;
            }
            TileEntity tile = world.func_175625_s(this.pos);
            if (tile instanceof TileFilteredRoutingNode) {
                ((TileFilteredRoutingNode)tile).setGhostItemAmount(this.ghostItemSlot, this.amount);
            }
        }
    }
}

