/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public abstract class AreaDescriptor
implements Iterator<BlockPos> {
    public List<BlockPos> getContainedPositions(BlockPos pos) {
        return new ArrayList<BlockPos>();
    }

    public AxisAlignedBB getAABB(BlockPos pos) {
        return null;
    }

    public abstract void resetCache();

    public abstract boolean isWithinArea(BlockPos var1);

    public abstract void resetIterator();

    public void readFromNBT(NBTTagCompound tag) {
    }

    public void writeToNBT(NBTTagCompound tag) {
    }

    public abstract int getVolumeForOffsets(BlockPos var1, BlockPos var2);

    public abstract boolean isWithinRange(BlockPos var1, BlockPos var2, int var3, int var4);

    public abstract int getVolume();

    public abstract int getHeight();

    public abstract boolean isWithinRange(int var1, int var2);

    public abstract void modifyAreaByBlockPositions(BlockPos var1, BlockPos var2);

    public abstract boolean intersects(AreaDescriptor var1);

    public abstract AreaDescriptor offset(BlockPos var1);

    public abstract AreaDescriptor rotateDescriptor(PlacementSettings var1);

    public static class Cross
    extends AreaDescriptor {
        private ArrayList<BlockPos> blockPosCache;
        private BlockPos cachedPosition;
        private BlockPos centerPos;
        private int size;
        private boolean cache = true;

        public Cross(BlockPos center, int size) {
            this.centerPos = center;
            this.size = size;
            this.blockPosCache = new ArrayList();
        }

        @Override
        public int getHeight() {
            return this.size * 2 + 1;
        }

        @Override
        public List<BlockPos> getContainedPositions(BlockPos pos) {
            if (!this.cache || !pos.equals((Object)this.cachedPosition) || this.blockPosCache.isEmpty()) {
                this.resetCache();
                this.blockPosCache.add(this.centerPos.func_177971_a((Vec3i)pos));
                for (int i = 1; i <= this.size; ++i) {
                    this.blockPosCache.add(this.centerPos.func_177971_a((Vec3i)pos).func_177982_a(i, 0, 0));
                    this.blockPosCache.add(this.centerPos.func_177971_a((Vec3i)pos).func_177982_a(0, 0, i));
                    this.blockPosCache.add(this.centerPos.func_177971_a((Vec3i)pos).func_177982_a(-i, 0, 0));
                    this.blockPosCache.add(this.centerPos.func_177971_a((Vec3i)pos).func_177982_a(0, 0, -i));
                }
            }
            this.cachedPosition = pos;
            return Collections.unmodifiableList(this.blockPosCache);
        }

        @Override
        public void resetCache() {
            this.blockPosCache = new ArrayList();
        }

        @Override
        public boolean isWithinArea(BlockPos pos) {
            return this.blockPosCache.contains(pos);
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public BlockPos next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void resetIterator() {
        }

        @Override
        public void modifyAreaByBlockPositions(BlockPos pos1, BlockPos pos2) {
        }

        @Override
        public int getVolumeForOffsets(BlockPos pos1, BlockPos pos2) {
            return 0;
        }

        @Override
        public boolean isWithinRange(BlockPos offset1, BlockPos offset2, int verticalLimit, int horizontalLimit) {
            return false;
        }

        @Override
        public int getVolume() {
            return 0;
        }

        @Override
        public boolean isWithinRange(int verticalLimit, int horizontalLimit) {
            return false;
        }

        @Override
        public boolean intersects(AreaDescriptor descriptor) {
            return false;
        }

        @Override
        public AreaDescriptor offset(BlockPos offset) {
            return new Cross(this.centerPos.func_177971_a((Vec3i)offset), this.size);
        }

        @Override
        public AreaDescriptor rotateDescriptor(PlacementSettings settings) {
            return this;
        }
    }

    public static class HemiSphere
    extends AreaDescriptor {
        private BlockPos minimumOffset;
        private int radius;
        private ArrayList<BlockPos> blockPosCache;
        private BlockPos cachedPosition;
        private boolean cache = true;

        public HemiSphere(BlockPos minimumOffset, int radius) {
            this.setRadius(minimumOffset, radius);
        }

        public void setRadius(BlockPos minimumOffset, int radius) {
            this.minimumOffset = new BlockPos(Math.min(minimumOffset.func_177958_n(), minimumOffset.func_177958_n()), Math.min(minimumOffset.func_177956_o(), minimumOffset.func_177956_o()), Math.min(minimumOffset.func_177952_p(), minimumOffset.func_177952_p()));
            this.radius = radius;
            this.blockPosCache = new ArrayList();
        }

        @Override
        public int getHeight() {
            return this.radius * 2;
        }

        @Override
        public List<BlockPos> getContainedPositions(BlockPos pos) {
            if (!this.cache || !pos.equals((Object)this.cachedPosition) || this.blockPosCache.isEmpty()) {
                ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
                int j = this.minimumOffset.func_177956_o();
                int k = -this.radius;
                for (int i = -this.radius; i <= this.radius; ++i) {
                    while (j <= this.radius) {
                        while (k <= this.radius) {
                            if ((float)(i * i + j * j + k * k) >= ((float)this.radius + 0.5f) * ((float)this.radius + 0.5f)) {
                                ++k;
                                continue;
                            }
                            posList.add(pos.func_177982_a(i, j, k));
                            ++k;
                        }
                        k = -this.radius;
                        ++j;
                    }
                    j = this.minimumOffset.func_177956_o();
                }
                this.blockPosCache = posList;
                this.cachedPosition = pos;
            }
            return Collections.unmodifiableList(this.blockPosCache);
        }

        @Override
        public AxisAlignedBB getAABB(BlockPos pos) {
            return null;
        }

        @Override
        public void resetCache() {
            this.blockPosCache = new ArrayList();
        }

        @Override
        public boolean isWithinArea(BlockPos pos) {
            return this.blockPosCache.contains(pos);
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public BlockPos next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void resetIterator() {
        }

        @Override
        public void modifyAreaByBlockPositions(BlockPos pos1, BlockPos pos2) {
        }

        @Override
        public int getVolumeForOffsets(BlockPos pos1, BlockPos pos2) {
            return 0;
        }

        @Override
        public boolean isWithinRange(BlockPos offset1, BlockPos offset2, int verticalLimit, int horizontalLimit) {
            return false;
        }

        @Override
        public int getVolume() {
            return 0;
        }

        @Override
        public boolean isWithinRange(int verticalLimit, int horizontalLimit) {
            return false;
        }

        @Override
        public boolean intersects(AreaDescriptor descriptor) {
            return false;
        }

        @Override
        public AreaDescriptor offset(BlockPos offset) {
            return new HemiSphere(this.minimumOffset.func_177971_a((Vec3i)offset), this.radius);
        }

        @Override
        public AreaDescriptor rotateDescriptor(PlacementSettings settings) {
            return this;
        }
    }

    public static class Rectangle
    extends AreaDescriptor {
        protected BlockPos minimumOffset;
        protected BlockPos maximumOffset;
        private BlockPos currentPosition;
        private ArrayList<BlockPos> blockPosCache;
        private BlockPos cachedPosition;
        private boolean cache = true;

        public Rectangle(BlockPos minimumOffset, BlockPos maximumOffset) {
            this.setOffsets(minimumOffset, maximumOffset);
        }

        public Rectangle(BlockPos minimumOffset, int sizeX, int sizeY, int sizeZ) {
            this(minimumOffset, minimumOffset.func_177982_a(sizeX, sizeY, sizeZ));
        }

        public Rectangle(BlockPos minimumOffset, int size) {
            this(minimumOffset, size, size, size);
        }

        @Override
        public List<BlockPos> getContainedPositions(BlockPos pos) {
            if (!this.cache || !pos.equals((Object)this.cachedPosition) || this.blockPosCache.isEmpty()) {
                ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
                for (int j = this.minimumOffset.func_177956_o(); j < this.maximumOffset.func_177956_o(); ++j) {
                    for (int i = this.minimumOffset.func_177958_n(); i < this.maximumOffset.func_177958_n(); ++i) {
                        for (int k = this.minimumOffset.func_177952_p(); k < this.maximumOffset.func_177952_p(); ++k) {
                            posList.add(pos.func_177982_a(i, j, k));
                        }
                    }
                }
                this.blockPosCache = posList;
                this.cachedPosition = pos;
            }
            return Collections.unmodifiableList(this.blockPosCache);
        }

        @Override
        public AxisAlignedBB getAABB(BlockPos pos) {
            AxisAlignedBB tempAABB = new AxisAlignedBB(this.minimumOffset, this.maximumOffset);
            return tempAABB.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }

        @Override
        public int getHeight() {
            return this.maximumOffset.func_177956_o() - this.minimumOffset.func_177956_o();
        }

        public void setOffsets(BlockPos offset1, BlockPos offset2) {
            this.minimumOffset = new BlockPos(Math.min(offset1.func_177958_n(), offset2.func_177958_n()), Math.min(offset1.func_177956_o(), offset2.func_177956_o()), Math.min(offset1.func_177952_p(), offset2.func_177952_p()));
            this.maximumOffset = new BlockPos(Math.max(offset1.func_177958_n(), offset2.func_177958_n()), Math.max(offset1.func_177956_o(), offset2.func_177956_o()), Math.max(offset1.func_177952_p(), offset2.func_177952_p()));
            this.blockPosCache = new ArrayList();
        }

        @Override
        public void resetCache() {
            this.blockPosCache = new ArrayList();
        }

        @Override
        public boolean isWithinArea(BlockPos pos) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            return x >= this.minimumOffset.func_177958_n() && x < this.maximumOffset.func_177958_n() && y >= this.minimumOffset.func_177956_o() && y < this.maximumOffset.func_177956_o() && z >= this.minimumOffset.func_177952_p() && z < this.maximumOffset.func_177952_p();
        }

        @Override
        public boolean hasNext() {
            return this.currentPosition == null || this.currentPosition.func_177958_n() + 1 != this.maximumOffset.func_177958_n() || this.currentPosition.func_177956_o() + 1 != this.maximumOffset.func_177956_o() || this.currentPosition.func_177952_p() + 1 != this.maximumOffset.func_177952_p();
        }

        @Override
        public BlockPos next() {
            if (this.currentPosition != null) {
                int nextX;
                int n = nextX = this.currentPosition.func_177958_n() + 1 >= this.maximumOffset.func_177958_n() ? this.minimumOffset.func_177958_n() : this.currentPosition.func_177958_n() + 1;
                int nextZ = nextX != this.minimumOffset.func_177958_n() ? this.currentPosition.func_177952_p() : (this.currentPosition.func_177952_p() + 1 >= this.maximumOffset.func_177952_p() ? this.minimumOffset.func_177952_p() : this.currentPosition.func_177952_p() + 1);
                int nextY = nextZ != this.minimumOffset.func_177952_p() || nextX != this.minimumOffset.func_177958_n() ? this.currentPosition.func_177956_o() : this.currentPosition.func_177956_o() + 1;
                this.currentPosition = new BlockPos(nextX, nextY, nextZ);
            } else {
                this.currentPosition = this.minimumOffset;
            }
            return this.currentPosition;
        }

        @Override
        public void remove() {
        }

        @Override
        public void resetIterator() {
            this.currentPosition = null;
        }

        @Override
        public void modifyAreaByBlockPositions(BlockPos pos1, BlockPos pos2) {
            this.setOffsets(pos1, pos2);
            this.maximumOffset = this.maximumOffset.func_177982_a(1, 1, 1);
            this.resetIterator();
            this.resetCache();
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.minimumOffset = new BlockPos(tag.func_74762_e("xCoordmin"), tag.func_74762_e("yCoordmin"), tag.func_74762_e("zCoordmin"));
            this.maximumOffset = new BlockPos(tag.func_74762_e("xCoordmax"), tag.func_74762_e("yCoordmax"), tag.func_74762_e("zCoordmax"));
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("xCoordmin", this.minimumOffset.func_177958_n());
            tag.func_74768_a("yCoordmin", this.minimumOffset.func_177956_o());
            tag.func_74768_a("zCoordmin", this.minimumOffset.func_177952_p());
            tag.func_74768_a("xCoordmax", this.maximumOffset.func_177958_n());
            tag.func_74768_a("yCoordmax", this.maximumOffset.func_177956_o());
            tag.func_74768_a("zCoordmax", this.maximumOffset.func_177952_p());
        }

        @Override
        public int getVolumeForOffsets(BlockPos offset1, BlockPos offset2) {
            BlockPos minPos = new BlockPos(Math.min(offset1.func_177958_n(), offset2.func_177958_n()), Math.min(offset1.func_177956_o(), offset2.func_177956_o()), Math.min(offset1.func_177952_p(), offset2.func_177952_p()));
            BlockPos maxPos = new BlockPos(Math.max(offset1.func_177958_n(), offset2.func_177958_n()), Math.max(offset1.func_177956_o(), offset2.func_177956_o()), Math.max(offset1.func_177952_p(), offset2.func_177952_p()));
            maxPos = maxPos.func_177982_a(1, 1, 1);
            return (maxPos.func_177958_n() - minPos.func_177958_n()) * (maxPos.func_177956_o() - minPos.func_177956_o()) * (maxPos.func_177952_p() - minPos.func_177952_p());
        }

        @Override
        public boolean isWithinRange(BlockPos offset1, BlockPos offset2, int verticalLimit, int horizontalLimit) {
            BlockPos minPos = new BlockPos(Math.min(offset1.func_177958_n(), offset2.func_177958_n()), Math.min(offset1.func_177956_o(), offset2.func_177956_o()), Math.min(offset1.func_177952_p(), offset2.func_177952_p()));
            BlockPos maxPos = new BlockPos(Math.max(offset1.func_177958_n(), offset2.func_177958_n()), Math.max(offset1.func_177956_o(), offset2.func_177956_o()), Math.max(offset1.func_177952_p(), offset2.func_177952_p()));
            return minPos.func_177956_o() >= -verticalLimit && maxPos.func_177956_o() <= verticalLimit && minPos.func_177958_n() >= -horizontalLimit && maxPos.func_177958_n() <= horizontalLimit && minPos.func_177952_p() >= -horizontalLimit && maxPos.func_177952_p() <= horizontalLimit;
        }

        @Override
        public int getVolume() {
            return (this.maximumOffset.func_177958_n() - this.minimumOffset.func_177958_n()) * (this.maximumOffset.func_177956_o() - this.minimumOffset.func_177956_o()) * (this.maximumOffset.func_177952_p() - this.minimumOffset.func_177952_p());
        }

        @Override
        public boolean isWithinRange(int verticalLimit, int horizontalLimit) {
            return this.minimumOffset.func_177956_o() >= -verticalLimit && this.maximumOffset.func_177956_o() <= verticalLimit + 1 && this.minimumOffset.func_177958_n() >= -horizontalLimit && this.maximumOffset.func_177958_n() <= horizontalLimit + 1 && this.minimumOffset.func_177952_p() >= -horizontalLimit && this.maximumOffset.func_177952_p() <= horizontalLimit + 1;
        }

        @Override
        public boolean intersects(AreaDescriptor descriptor) {
            if (descriptor instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)descriptor;
                return this.minimumOffset.func_177958_n() < rectangle.maximumOffset.func_177958_n() && this.minimumOffset.func_177956_o() < rectangle.maximumOffset.func_177956_o() && this.minimumOffset.func_177952_p() < rectangle.maximumOffset.func_177952_p() && rectangle.minimumOffset.func_177958_n() < this.maximumOffset.func_177958_n() && rectangle.minimumOffset.func_177956_o() < this.maximumOffset.func_177956_o() && rectangle.minimumOffset.func_177952_p() < this.maximumOffset.func_177952_p();
            }
            return false;
        }

        @Override
        public AreaDescriptor offset(BlockPos offset) {
            return new Rectangle(this.minimumOffset.func_177971_a((Vec3i)offset), this.maximumOffset.func_177971_a((Vec3i)offset));
        }

        @Override
        public AreaDescriptor rotateDescriptor(PlacementSettings settings) {
            BlockPos rotatePos1 = Template.func_186266_a((PlacementSettings)settings, (BlockPos)this.minimumOffset);
            BlockPos rotatePos2 = Template.func_186266_a((PlacementSettings)settings, (BlockPos)this.maximumOffset.func_177982_a(-1, -1, -1));
            Rectangle rectangle = new Rectangle(this.minimumOffset, 1);
            rectangle.modifyAreaByBlockPositions(rotatePos1, rotatePos2);
            return rectangle;
        }
    }
}

