/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.harvest;

import WayofTime.bloodmagic.ritual.harvest.HarvestRegistry;
import WayofTime.bloodmagic.ritual.harvest.IHarvestHandler;
import WayofTime.bloodmagic.util.BMLog;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class HarvestHandlerPlantable
implements IHarvestHandler {
    public HarvestHandlerPlantable() {
        HarvestRegistry.registerStandardCrop(Blocks.field_150459_bM, 7);
        HarvestRegistry.registerStandardCrop(Blocks.field_150464_aj, 7);
        HarvestRegistry.registerStandardCrop(Blocks.field_150469_bN, 7);
        HarvestRegistry.registerStandardCrop(Blocks.field_185773_cZ, 3);
        HarvestRegistry.registerStandardCrop(Blocks.field_150388_bm, 3);
        HarvestHandlerPlantable.addThirdPartyCrop("actuallyadditions", "blockFlax", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("actuallyadditions", "blockCanola", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("actuallyadditions", "blockRice", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("extrautils2", "redorchid", 6);
        HarvestHandlerPlantable.addThirdPartyCrop("extrautils2", "enderlily", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "moonglow", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "terra_moss", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "pereskia", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "wildroot", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "aubergine", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "spirit_herb", 7);
        HarvestHandlerPlantable.addPamCrops();
    }

    @Override
    public boolean harvest(World world, BlockPos pos, IBlockState state, List<ItemStack> drops) {
        NonNullList blockDrops = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(blockDrops, (IBlockAccess)world, pos, state, 0);
        boolean foundSeed = false;
        for (ItemStack stack : blockDrops) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IPlantable)) continue;
            stack.func_190918_g(1);
            foundSeed = true;
            break;
        }
        if (foundSeed) {
            world.func_175656_a(pos, state.func_177230_c().func_176223_P());
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            for (ItemStack stack : blockDrops) {
                if (stack.func_190926_b()) continue;
                drops.add(stack);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean test(World world, BlockPos pos, IBlockState state) {
        return HarvestRegistry.getStandardCrops().containsKey(state.func_177230_c()) && state.func_177230_c().func_176201_c(state) == HarvestRegistry.getStandardCrops().get(state.func_177230_c()).intValue();
    }

    private static void addThirdPartyCrop(String modid, String regName, int matureMeta) {
        if (!Loader.isModLoaded((String)modid)) {
            return;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modid, regName));
        if (block != null && block != Blocks.field_150350_a) {
            HarvestRegistry.registerStandardCrop(block, matureMeta);
        }
    }

    private static void addPamCrops() {
        if (!Loader.isModLoaded((String)"harvestcraft")) {
            return;
        }
        try {
            Class<?> pamRegistry = Class.forName("com.pam.harvestcraft.blocks.CropRegistry");
            Field names = pamRegistry.getDeclaredField("cropNames");
            Method getCrop = pamRegistry.getMethod("getCrop", String.class);
            for (String name : (String[])names.get(null)) {
                BlockCrops crop = (BlockCrops)getCrop.invoke(null, name);
                HarvestRegistry.registerStandardCrop((Block)crop, crop.func_185526_g());
            }
        }
        catch (ClassNotFoundException e) {
            BMLog.DEFAULT.error("HarvestCraft integration cancelled; unable to find registry class", new Object[0]);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            BMLog.DEFAULT.error("HarvestCraft integration cancelled; unable to find crop name mapper", new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            BMLog.DEFAULT.error("HarvestCraft integration cancelled; crop name lookup broke", new Object[0]);
        }
    }
}

