/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.item.armour.ItemLivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@RitualRegister(value="armour_evolve")
public class RitualArmourEvolve
extends Ritual {
    public static final String CHECK_RANGE = "fillRange";

    public RitualArmourEvolve() {
        super("ritualArmourEvolve", 2, 50000, "ritual.bloodmagic.armourEvolveRitual");
        this.addBlockRange(CHECK_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1, 2, 1));
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        AreaDescriptor checkRange = masterRitualStone.getBlockRange(CHECK_RANGE);
        List playerList = world.func_72872_a(EntityPlayer.class, checkRange.getAABB(pos));
        for (EntityPlayer player : playerList) {
            ItemStack chestStack;
            LivingArmour armour;
            if (!LivingArmour.hasFullSet(player) || (armour = ItemLivingArmour.getLivingArmour(chestStack = ((ItemStack[])Iterables.toArray((Iterable)player.func_184193_aE(), ItemStack.class))[2])) == null || armour.maxUpgradePoints >= 300) continue;
            armour.maxUpgradePoints = 300;
            ((ItemLivingArmour)chestStack.func_77973_b()).setLivingArmour(chestStack, armour, true);
            masterRitualStone.setActive(false);
            world.func_72838_d((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() - 1), (double)pos.func_177952_p(), true));
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 0;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 0, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 1, 2, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 1, 1, EnumRuneType.DUSK);
        this.addParallelRunes(components, 4, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 1, 3, EnumRuneType.DUSK);
        this.addParallelRunes(components, 1, 4, EnumRuneType.EARTH);
        for (int i = 0; i < 4; ++i) {
            this.addCornerRunes(components, 3, i, EnumRuneType.EARTH);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualArmourEvolve();
    }
}

