/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.soul;

import WayofTime.bloodmagic.soul.EnumDemonWillType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class DemonWillHolder {
    public HashMap<EnumDemonWillType, Double> willMap = new HashMap();

    public double addWill(EnumDemonWillType type, double amount, double max) {
        double current = 0.0;
        if (this.willMap.containsKey(type)) {
            current = this.willMap.get(type);
        }
        double added = Math.min(max - current, amount);
        this.addWill(type, amount);
        return added;
    }

    public void addWill(EnumDemonWillType type, double amount) {
        if (this.willMap.containsKey(type)) {
            this.willMap.put(type, amount + this.willMap.get(type));
        } else {
            this.willMap.put(type, amount);
        }
    }

    public double drainWill(EnumDemonWillType type, double amount) {
        if (this.willMap.containsKey(type)) {
            double current = this.willMap.get(type);
            double reduced = Math.min(current, amount);
            if (reduced >= current) {
                this.willMap.remove(type);
            } else {
                this.willMap.put(type, current - reduced);
            }
            return reduced;
        }
        return 0.0;
    }

    public double getWill(EnumDemonWillType type) {
        if (this.willMap.containsKey(type)) {
            return this.willMap.get(type);
        }
        return 0.0;
    }

    public void readFromNBT(NBTTagCompound tag, String key) {
        NBTTagCompound willTag = tag.func_74775_l(key);
        this.willMap.clear();
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            double amount = willTag.func_74769_h("EnumWill" + type.func_176610_l());
            if (!(amount > 0.0)) continue;
            this.willMap.put(type, amount);
        }
    }

    public void writeToNBT(NBTTagCompound tag, String key) {
        NBTTagCompound willTag = new NBTTagCompound();
        for (Map.Entry<EnumDemonWillType, Double> entry : this.willMap.entrySet()) {
            willTag.func_74780_a("EnumWill" + entry.getKey().func_176610_l(), entry.getValue().doubleValue());
        }
        tag.func_74782_a(key, (NBTBase)willTag);
    }

    public void clearWill() {
        this.willMap.clear();
    }
}

